/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.List;

public abstract class AbstractLoadBalance<T>
implements LoadBalance<T> {
    public static final int MAX_REFERER_COUNT = 10;
    private List<Referer<T>> referers;

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        this.referers = referers;
    }

    @Override
    public Referer<T> select(Request request) {
        List<Referer<T>> referers = this.referers;
        Referer<T> ref = null;
        if (referers.size() > 1) {
            ref = this.doSelect(request);
        } else if (referers.size() == 1) {
            Referer<T> referer = ref = referers.get(0).isAvailable() ? referers.get(0) : null;
        }
        if (ref != null) {
            return ref;
        }
        throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call request:" + request);
    }

    @Override
    public void selectToHolder(Request request, List<Referer<T>> refersHolder) {
        List<Referer<T>> referers = this.referers;
        if (referers == null) {
            throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call : referers_size= 0 " + MotanFrameworkUtil.toString(request));
        }
        if (referers.size() > 1) {
            this.doSelectToHolder(request, refersHolder);
        } else if (referers.size() == 1 && referers.get(0).isAvailable()) {
            refersHolder.add(referers.get(0));
        }
        if (refersHolder.isEmpty()) {
            throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call : referers_size=" + referers.size() + " " + MotanFrameworkUtil.toString(request));
        }
    }

    protected List<Referer<T>> getReferers() {
        return this.referers;
    }

    @Override
    public void setWeightString(String weightString) {
        LoggerUtil.info("ignore weightString:" + weightString);
    }

    protected abstract Referer<T> doSelect(Request var1);

    protected abstract void doSelectToHolder(Request var1, List<Referer<T>> var2);
}

