/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SMetaDataProxy;
import com.vertica.jdbc.jdbc41.S41ResultSetMetaData;
import com.vertica.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41MetaDataProxy
extends SMetaDataProxy {
    protected S41MetaDataProxy(DatabaseMetaData dbMeta, IResultSet resultSet, MetadataSourceID metadataType, ILogger logger) throws SQLException {
        super(dbMeta, resultSet, metadataType, logger, JDBCVersion.JDBC41);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null == this.m_resultMetaData) {
            this.generateMetadataList();
            this.m_resultMetaData = new S41ResultSetMetaData(this.m_resultSetColumns, this.m_logger, this.m_warningListener);
        }
        return this.m_resultMetaData;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, type);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, columnIndex, type);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, type);
        return this.getObject(this.findColumn(columnLabel), type);
    }
}

