/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.util.ServerErrorData;
import java.io.IOException;

public final class ErrorResponseMessage
extends ResponseMessage {
    private ServerErrorData m_errorData;
    private LogLevel m_logLevel;
    private VConnection m_conn;

    protected ErrorResponseMessage(VConnection vConnection, VStream vStream, ILogger iLogger) {
        super(vStream);
        this.m_logLevel = iLogger.getLogLevel();
        this.m_conn = vConnection;
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        String string = this.m_vStream.ReceiveString(n);
        this.m_errorData = new ServerErrorData(string, this.m_logLevel, this.m_conn);
    }

    public ServerErrorData getErrorData() {
        return this.m_errorData;
    }

    @Override
    public MessageType getType() {
        return MessageType.Error;
    }
}

