/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.util;

import com.ustcinfo.bwp.BwpEngineException;
import com.ustcinfo.bwp.client.util.BwpServerUtil;
import com.ustcinfo.bwp.client.util.ParamName;
import com.ustcinfo.bwp.exception.BwpClientException;
import com.ustcinfo.bwp.modle.response.EngineResponse;
import com.ustcinfo.bwp.modle.response.ExceptionContent;
import com.ustcinfo.bwp.service.startflow.util.SerializeUtils;
import com.ustcinfo.bwp.support.Tenant;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class RequestExecutor {
    public static String execute(CloseableHttpClient client, String methodName, String txId, String invokeIndex, Object ... args) throws BwpEngineException {
        try {
            CloseableHttpResponse response;
            HttpPost httpPost = new HttpPost(BwpServerUtil.getURL(methodName));
            httpPost.setHeader("clientIP", InetAddress.getLocalHost().getHostAddress().toString());
            httpPost.setHeader("txId", txId);
            httpPost.setHeader("index", invokeIndex);
            httpPost.setHeader("tenantId", Tenant.tenantId);
            if (args != null && args.length > 0) {
                List<NameValuePair> params = RequestExecutor.buildParams(methodName, args);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                throw new BwpClientException("0200", "03", "\u8fde\u63a5BWP\u670d\u52a1\u7aef\u53d1\u751f\u9519\u8bef\uff01Failed with HTTP error code : " + response.getStatusLine().getStatusCode() + ", error message :" + response.getStatusLine().getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            String json = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            EngineResponse engineResponse = (EngineResponse)SerializeUtils.unserialize((String)json, EngineResponse.class);
            if (EngineResponse.SUCCESS == engineResponse.getCode()) {
                return engineResponse.getContent();
            }
            if (EngineResponse.FAILED == engineResponse.getCode()) {
                return RequestExecutor.buildException(engineResponse.getContent());
            }
            throw new BwpClientException("0200", "04", "BWP\u670d\u52a1\u7aef\u54cd\u5e94\u53d1\u751f\u9519\u8bef\uff01");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BwpClientException("0200", "05", "\u8fde\u63a5BWP\u670d\u52a1\u7aef\u5931\u8d25\uff01", (Exception)e);
        }
    }

    private static String buildException(String result) throws BwpEngineException {
        ExceptionContent exception = (ExceptionContent)SerializeUtils.unserialize((String)result, ExceptionContent.class);
        if (exception.getCauseType() != null) {
            Exception cause = null;
            try {
                Class<?> exceptiontype = Class.forName(exception.getCauseType());
                Constructor<?> constructor = exceptiontype.getDeclaredConstructor(String.class);
                cause = (Exception)constructor.newInstance(exception.getCauseMessage());
                cause.setStackTrace(exception.getStackTrace());
            }
            catch (Exception e) {
                BwpEngineException engException = new BwpEngineException(new StringBuffer(exception.getMessage()).append("\nCaused by: ").append(exception.getCauseType()).append(":").append(exception.getCauseMessage()).toString());
                engException.setStackTrace(exception.getStackTrace());
                throw engException;
            }
            throw new BwpEngineException(exception.getMessage(), (Throwable)cause);
        }
        throw new BwpEngineException(exception.getMessage());
    }

    private static List<NameValuePair> buildParams(String methodName, Object[] args) {
        ArrayList<String> paramNames = new ArrayList<String>(Arrays.asList(ParamName.valueOf(methodName).getParamName().split(",")));
        ArrayList<Object> paramValues = new ArrayList<Object>(Arrays.asList(args));
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        int index = 0;
        while (index < paramValues.size()) {
            String jsonParam = null;
            Object paramValue = paramValues.get(index);
            jsonParam = paramValue == null ? null : (paramValue instanceof String ? paramValue.toString() : SerializeUtils.serialize(paramValue));
            nvps.add((NameValuePair)new BasicNameValuePair((String)paramNames.get(index), jsonParam));
            ++index;
        }
        return nvps;
    }
}

