/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.util;

import com.ustcinfo.bwp.client.util.MethodPath;
import com.ustcinfo.bwp.exception.BwpClientException;
import com.ustcinfo.bwp.service.startflow.util.StringUtils;
import com.ustcinfo.bwp.support.Tenant;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class BwpServerUtil {
    private static Properties properties;
    private static final String CONFIG_FILE = "bwpServer.properties";
    private static final String BWP_CONTEXT = "/bwp";
    private static final String SERVER_HOSTS = "bwp.server.hosts";
    private static final String TENANT_ID = "bwp.tenant.id";
    private static List<String> restHosts;
    private static String bwpContext;

    static {
        BwpServerUtil.loadBwpConfiguration();
    }

    private static void loadBwpConfiguration() {
        InputStream inStream = BwpServerUtil.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        if (inStream == null) {
            throw new BwpClientException("0200", "01", "\u65e0\u6cd5\u627e\u5230\u914d\u7f6e\u6587\u4ef6bwpServer.properties\uff01");
        }
        properties = new Properties();
        try {
            try {
                properties.load(inStream);
                restHosts = Arrays.asList(properties.getProperty(SERVER_HOSTS).trim().split(";"));
                Tenant.tenantId = properties.getProperty(TENANT_ID).trim();
                if (properties.containsKey("bwp.server.context")) {
                    bwpContext = properties.getProperty("bwp.server.context").trim();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BwpClientException("0200", "02", "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6bwpServer.properties\u5931\u8d25\uff01", (Exception)e);
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String getURL(String methodName) {
        return new StringBuffer(restHosts.get(0)).append(StringUtils.hasText((String)bwpContext) ? bwpContext : BWP_CONTEXT).append(BwpServerUtil.getMethodPath(methodName)).toString();
    }

    private static String getMethodPath(String methodName) {
        return MethodPath.valueOf(methodName).getPath();
    }
}

