/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.impl;

import com.ustcinfo.bwp.BwpEngineException;
import com.ustcinfo.bwp.client.impl.TxRestClient;
import com.ustcinfo.bwp.client.util.RequestExecutor;
import com.ustcinfo.bwp.modle.ActivityInst;
import com.ustcinfo.bwp.modle.ActivityRepo;
import com.ustcinfo.bwp.modle.Participant;
import com.ustcinfo.bwp.service.ActivityService;
import com.ustcinfo.bwp.service.startflow.util.SerializeUtils;
import java.util.List;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;

public class ActivityRestClient
implements ActivityService {
    private CloseableHttpClient httpClient;

    private ActivityRestClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean startActivity(Long processInstId, String activityDefId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityDefId));
    }

    public boolean terminateActivity(Long processInstId, Long activityInstId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityInstId));
    }

    public boolean finishCurrentActivity(Long processInstId, String userId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, userId));
    }

    public boolean finishActivity(Long processInstId, Long activityInstId, String userId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityInstId, userId));
    }

    public boolean activateCurrentActivity(Long processInstId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId));
    }

    public boolean activateActivity(Long processInstId, Long activityInstId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityInstId));
    }

    public boolean reStartActivity(Long processInstId, Long activityInstId) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityInstId));
    }

    public boolean changeActLimitTime(Long processInstId, Long activityInstId, Double limitTime) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityInstId, limitTime));
    }

    public boolean setNextActParticipants(Long processInstId, String activityDefId, List<Participant> nextActParticipants) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityDefId, nextActParticipants));
    }

    public boolean setExpressConditions(Long processInstId, String activityDefId, Map<String, Object> conditions) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), processInstId, activityDefId, conditions));
    }

    public String getActivityClass(Long processInstId, String activityDefId) {
        try {
            return (String)SerializeUtils.unserialize((String)RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId), String.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ActivityInst> getAllCurrentActivitys(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return SerializeUtils.getBeanList((String)json, ActivityInst[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getActDefIdByActInstId(Long processInstId, Long activityInstId) {
        try {
            return (String)SerializeUtils.unserialize((String)RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityInstId), String.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getActRepoIdByActInstId(Long processInstId, Long activityInstId) {
        try {
            return (String)SerializeUtils.unserialize((String)RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityInstId), String.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Participant> getActParticipants(Long processInstId, Long activityInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityInstId);
            return SerializeUtils.getBeanList((String)json, Participant[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> getExpressConditions(Long processInstId, String activityDefId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId);
            return SerializeUtils.getMap((String)json, String.class, Object.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Participant> getNextActParticipants(Long processInstId, String activityDefId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId);
            return SerializeUtils.getBeanList((String)json, Participant[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ActivityRepo> getNextActRepo(Long processInstId, String activityDefId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId);
            return SerializeUtils.getBeanList((String)json, ActivityRepo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }
}

