
-- 删除已存在的表

DROP TABLE  schedule_job;
DROP TABLE schedule_job_log;
DROP TABLE sys_dict;
DROP TABLE sys_dict_type;
DROP TABLE sys_log;
DROP TABLE sys_menu;
DROP TABLE sys_role;
DROP TABLE sys_role_menu;
DROP TABLE sys_user;
DROP TABLE sys_user_role;

--  开始创建表

-- ----------------------------
-- Table structure for schedule_job
-- ----------------------------
CREATE TABLE schedule_job (
  job_id NVARCHAR2(64) NOT NULL ,
  class_name NVARCHAR2(200) ,
  method_name NVARCHAR2(100) ,
  params NCLOB ,
  cron_expression NVARCHAR2(100) ,
  status NUMBER(4) ,
  remark NVARCHAR2(255) ,
  create_time DATE ,
  create_user_id NUMBER(20) NOT NULL ,
  del_flag NUMBER(11),
  PRIMARY KEY (job_id)
);
COMMENT ON TABLE  schedule_job IS '定时任务';
COMMENT ON COLUMN schedule_job.job_id IS '任务id';
COMMENT ON COLUMN schedule_job.class_name IS 'spring bean名称';
COMMENT ON COLUMN schedule_job.method_name IS '方法名';
COMMENT ON COLUMN schedule_job.params IS '参数';
COMMENT ON COLUMN schedule_job.cron_expression IS 'cron表达式';
COMMENT ON COLUMN schedule_job.status IS '任务状态  0：正常  1：暂停';
COMMENT ON COLUMN schedule_job.remark IS '备注';
COMMENT ON COLUMN schedule_job.create_time IS '创建时间';
COMMENT ON COLUMN schedule_job.create_user_id IS '创建者ID';

-- ----------------------------
-- Table structure for schedule_job_log
-- ----------------------------
CREATE TABLE schedule_job_log (
  log_id NVARCHAR2(64) NOT NULL ,
  job_id NVARCHAR2(64) NOT NULL ,
  class_name NVARCHAR2(200) ,
  method_name NVARCHAR2(100) ,
  params NCLOB ,
  status NUMBER(4) NOT NULL ,
  error NCLOB ,
  times NUMBER(11) NOT NULL ,
  create_time DATE ,
  create_user_id NVARCHAR2(64) NOT NULL,
  PRIMARY KEY (log_id)
);
COMMENT ON TABLE  schedule_job_log IS '定时任务日志';
COMMENT ON COLUMN schedule_job_log.log_id IS '任务日志id';
COMMENT ON COLUMN schedule_job_log.job_id IS '任务id';
COMMENT ON COLUMN schedule_job_log.class_name IS 'spring bean名称';
COMMENT ON COLUMN schedule_job_log.method_name IS '方法名';
COMMENT ON COLUMN schedule_job_log.params IS '参数';
COMMENT ON COLUMN schedule_job_log.status IS '任务状态    0：成功    1：失败';
COMMENT ON COLUMN schedule_job_log.error IS '失败信息';
COMMENT ON COLUMN schedule_job_log.times IS '耗时(单位：毫秒)';
COMMENT ON COLUMN schedule_job_log.create_time IS '创建时间';
COMMENT ON COLUMN schedule_job_log.create_user_id IS '创建者ID';

-- ----------------------------
-- Table structure for sys_dict
-- ----------------------------
CREATE TABLE sys_dict (
  id NVARCHAR2(64) NOT NULL ,
  dict_type_id NVARCHAR2(64) NOT NULL ,
  param_key NVARCHAR2(250) ,
  param_value NCLOB ,
  status NUMBER(4) ,
  order_num NUMBER(11) ,
  remark NVARCHAR2(500) ,
  del_flag NUMBER(11) ,
  del_token NVARCHAR2(64),
  PRIMARY KEY (id)
);
COMMENT ON COLUMN sys_dict.dict_type_id IS '业务字典类型ID';
COMMENT ON COLUMN sys_dict.param_key IS 'key';
COMMENT ON COLUMN sys_dict.param_value IS 'value';
COMMENT ON COLUMN sys_dict.status IS '状态   0：隐藏   1：显示';
COMMENT ON COLUMN sys_dict.order_num IS '排序';
COMMENT ON COLUMN sys_dict.remark IS '备注';
COMMENT ON TABLE sys_dict IS '系统业务字典表';
-- 创建约束
ALTER TABLE sys_dict ADD CONSTRAINT sys_dict_key_uniq UNIQUE(dict_type_id,param_key,del_token);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
CREATE TABLE sys_dict_type (
  id NVARCHAR2(64) NOT NULL ,
  type NVARCHAR2(250) NOT NULL ,
  status NUMBER(4) ,
  order_num NUMBER(4) ,
  remark NVARCHAR2(500) ,
  del_flag NUMBER(11) ,
  del_token NVARCHAR2(64),
  PRIMARY KEY (id)
);

COMMENT ON COLUMN sys_dict_type.type IS '类型';
COMMENT ON COLUMN sys_dict_type.status IS '状态   0：隐藏   1：显示';
COMMENT ON COLUMN sys_dict_type.order_num IS '排序';
COMMENT ON COLUMN sys_dict_type.remark IS '备注';
COMMENT ON TABLE  sys_dict_type IS '系统业务字典类型表';
-- 类型约束
ALTER TABLE sys_dict_type ADD CONSTRAINT sys_dict_type_uniq UNIQUE(type,del_token);

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
CREATE TABLE sys_log (
  id NVARCHAR2(64) NOT NULL ,
  type int NOT NULL,
  username NVARCHAR2(50) ,
  operation NVARCHAR2(50) ,
  method NVARCHAR2(200) ,
  params NCLOB ,
  time NUMBER(20) NOT NULL ,
  ip NVARCHAR2(64) ,
  request_uri NVARCHAR2(100) ,
  create_time DATE,
  user_id NVARCHAR2(64) DEFAULT NULL ,
  PRIMARY KEY (id)
);

COMMENT ON COLUMN sys_log.username IS '用户名';
COMMENT ON COLUMN sys_log.operation IS '用户操作';
COMMENT ON COLUMN sys_log.method IS '请求方法';
COMMENT ON COLUMN sys_log.params IS '请求参数';
COMMENT ON COLUMN sys_log.time IS '执行时长(毫秒)';
COMMENT ON COLUMN sys_log.ip IS 'IP地址';
COMMENT ON COLUMN sys_log.request_uri IS '请求地址';
COMMENT ON COLUMN sys_log.create_time IS '创建时间';
COMMENT ON TABLE  sys_log IS '系统日志';

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
CREATE TABLE sys_menu (
  menu_id NVARCHAR2(64) NOT NULL ,
  parent_id NVARCHAR2(64) ,
  name NVARCHAR2(50) ,
  url NVARCHAR2(200) ,
  perms NVARCHAR2(500) ,
  type NUMBER(11) ,
  icon NVARCHAR2(50) ,
  order_num NUMBER(11) ,
  status NUMBER(11) ,
  del_flag NUMBER(11) ,
  del_token NVARCHAR2(64),
   PRIMARY KEY (menu_id)
);

COMMENT ON COLUMN sys_menu.parent_id IS '父菜单ID，一级菜单为0';
COMMENT ON COLUMN sys_menu.name IS '菜单名称';
COMMENT ON COLUMN sys_menu.url IS '菜单URL';
COMMENT ON COLUMN sys_menu.perms IS '授权(多个用逗号分隔，如：user:list,user:create)';
COMMENT ON COLUMN sys_menu.type IS '类型   0：目录   1：菜单   2：按钮';
COMMENT ON COLUMN sys_menu.icon IS '菜单图标';
COMMENT ON COLUMN sys_menu.order_num IS '排序';
COMMENT ON TABLE sys_menu IS '菜单管理';

-- 菜单名称唯一
ALTER TABLE sys_menu ADD CONSTRAINT sys_menu_name_uniq UNIQUE(parent_id,name,del_token);


-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
CREATE TABLE sys_role (
  role_id NVARCHAR2(64) NOT NULL ,
  role_name NVARCHAR2(100) ,
  remark NVARCHAR2(100) ,
  create_time DATE ,
  del_flag NUMBER(11) ,
  del_token NVARCHAR2(64),
  PRIMARY KEY (role_id)
);
COMMENT ON COLUMN sys_role.role_name IS '角色名称';
COMMENT ON COLUMN sys_role.remark IS '备注';
COMMENT ON COLUMN sys_role.create_time IS '创建时间';
COMMENT ON TABLE  sys_role IS '角色';

--  角色名称唯一
ALTER TABLE sys_role ADD CONSTRAINT sys_role_name_uniq UNIQUE(role_name,del_token);

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
CREATE TABLE sys_role_menu (
  id NVARCHAR2(64) NOT NULL ,
  role_id NVARCHAR2(64) ,
  menu_id NVARCHAR2(64) ,
  checked NUMBER(11) ,
  del_flag NUMBER(11),
  PRIMARY KEY (id)
);

COMMENT ON COLUMN sys_role_menu.role_id IS '角色ID';
COMMENT ON COLUMN sys_role_menu.menu_id IS '菜单ID';
COMMENT ON TABLE  sys_role_menu IS '角色与菜单对应关系';


-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
CREATE TABLE sys_user (
  user_id NVARCHAR2(64) NOT NULL ,
  username NVARCHAR2(50) NOT NULL ,
  password NVARCHAR2(100) ,
  email NVARCHAR2(100) ,
  mobile NVARCHAR2(100) ,
  status NUMBER(4),
  create_time DATE ,
  del_flag NUMBER(11) ,
  del_token NVARCHAR2(64),
   PRIMARY KEY (user_id)
);
COMMENT ON COLUMN sys_user.username IS '用户名';
COMMENT ON COLUMN sys_user.password IS '密码';
COMMENT ON COLUMN sys_user.email IS '邮箱';
COMMENT ON COLUMN sys_user.mobile IS '手机号';
COMMENT ON COLUMN sys_user.status IS '状态  0：禁用   1：正常';
COMMENT ON COLUMN sys_user.create_time IS '创建时间';
COMMENT ON TABLE  sys_user IS '系统用户';

-- 用户名唯一
ALTER TABLE sys_user ADD CONSTRAINT sys_user_name_uniq UNIQUE(username,del_token);
-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
CREATE TABLE sys_user_role (
  id NVARCHAR2(64) NOT NULL ,
  user_id NVARCHAR2(64) ,
  role_id NVARCHAR2(64) ,
  del_flag NUMBER(11),
  PRIMARY KEY (id)
);

COMMENT ON COLUMN sys_user_role.user_id IS '用户ID';
COMMENT ON COLUMN sys_user_role.role_id IS '角色ID';
COMMENT ON TABLE  sys_user_role IS '用户与角色对应关系';


-- 以下开始导入初始化数据
-- 导入用户信息
INSERT INTO sys_user(user_id,username,password,email,mobile,status,create_time,del_flag,del_token)VALUES ('1', 'admin', 'e2b3678e8af69ade303325a17c7f9059bfcdf054c20cf899279df60afcd783c3', NULL , NULL , 1, CURRENT_DATE, 0, '0');

-- 导入角色信息
INSERT INTO sys_role(role_id,role_name,remark,create_time,del_flag,del_token)VALUES ('1', '系统管理员', NULL , CURRENT_DATE, 0, '0');
INSERT INTO sys_role(role_id,role_name,remark,create_time,del_flag,del_token)VALUES ('25', '普通用户' , NULL , CURRENT_DATE, 0, '0');

-- 导入菜单信息
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('1', '0', '系统管理', null, null, 0, 'system', 100, 1, 0, '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('2', '1', '用户管理', 'basic/sys/user', null, '1', 'admin', 200, '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('200', '1', '在线用户','basic/sys/online-user', null, '1', 'admin', '500', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('3', '1', '角色管理', 'basic/sys/role', null, '1', 'role', '250', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('4', '1', '菜单管理', 'basic/sys/menu', null, '1', 'menu', '300', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('15', '2', '查看', null, 'sys:user:list,sys:user:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('16', '2', '新增', null, 'sys:user:save,sys:role:select', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('17', '2', '修改', null, 'sys:user:update,sys:role:select', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('18', '2', '删除', null, 'sys:user:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('19', '3', '查看', null, 'sys:role:list,sys:role:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('20', '3', '新增', null, 'sys:role:save,sys:menu:list', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('21', '3', '修改', null, 'sys:role:update,sys:menu:list', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('22', '3', '删除', null, 'sys:role:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('23', '4', '查看', null, 'sys:menu:list,sys:menu:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('24', '4', '新增', null, 'sys:menu:save,sys:menu:select', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('25', '4', '修改', null, 'sys:menu:update,sys:menu:select', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('26', '4', '删除', null, 'sys:menu:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('29', '1', '系统日志', 'basic/sys/log', '', '1', 'log', '450', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('32', '1', '首页', 'basic/examples/echarts/index', null, '1', 'shouye', '150', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('34', '1', '基础设置', 'basic/sys/setting', null, '1', 'system', '400', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('48', '34', 'logo查看', null, 'sys:logo:view', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('49', '34', 'logo删除', null, 'sys:logo:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('50', '34', 'logo激活', null, 'sys:logo:edit', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('51', '34', 'logo默认获取', null, 'sys:logo:view', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('52', '34', '背景图片查看', null, 'sys:bg:view', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('53', '34', '背景图上传', null, 'sys:bg:edit', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('54', '34', '背景图片删除', null, 'sys:bg:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('55', '34', '系统信息修改', null, 'sys:info:edit', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('60', '1', '字典管理', 'basic/sys/dict', null, '1', 'bianji', '350', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('61', '60', '类型添加', null, 'sys:dict_type:save', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('62', '60', '类型修改', null, 'sys:dict_type:update', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('63', '60', '类型获取', null, 'sys:dict_type:select', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('64', '60', '类型详情', null, 'sys:dict_type:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('65', '60', '类型删除', null, 'sys:dict_type:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('66', '60', '字典获取', null, 'sys:dict:list', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('67', '60', '字典详情', null, 'sys:dict:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('68', '60', '字典添加', null, 'sys:dict:save', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('69', '60', '字典修改', null, 'sys:dict:update', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('70', '60', '字典删除', null, 'sys:dict:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('81', '0', '其他', null, null, '0', 'zonghe', '1000', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('82', '81', '定时任务', 'basic/quartz/quartz', null, '1', 'job', '1100', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('83', '82', '查看', null, 'sys:schedule:list', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('84', '82', '详情', null, 'sys:schedule:info', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('85', '82', '新增', null, 'sys:schedule:save', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('86', '82', '修改', null, 'sys:schedule:update', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('87', '82', '删除', null, 'sys:schedule:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('88', '82', '执行', null, 'sys:schedule:run', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('89', '82', '暂停', null, 'sys:schedule:pause', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('90', '82', '恢复', null, 'sys:schedule:resume', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('91', '82', '查看日志', null, 'sys:schedule:log', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('92', '81', 'SQL监控', 'http://localhost:8081/eip-admin-rest/druid/sql.html', null, '1', 'sql', '1200', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('93', '34', '网站图标查看', null, 'sys:favicon:view', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('94', '34', '网站图标上传', null, 'sys:favicon:edit', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('95', '34', '网站图标删除', null, 'sys:favicon:delete', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('96', '34', '网站图标切换', null, 'sys:favicon:edit', '2', null, '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('102', '29', '日志级别查看', '', 'sys:logger:view', '2', '', '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('103', '29', '日志级别修改', '', 'sys:logger:edit', '2', '', '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES  ('104', '29', '日志查看', '', 'sys:log:list', '2', '', '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('105', '2', '禁用用户', '', 'sys:user:lock', '2', '', '0', '1', '0', '0');
INSERT INTO sys_menu(menu_id,parent_id,name,url,perms,type,icon,order_num,status,del_flag,del_token) VALUES ('106', '2', '解锁用户', '', 'sys:user:unlock', '2', '', '0', '1', '0', '0');

-- 导入角色与菜单关系数据

INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES ('1688', '1', '1', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1689', '1', '32', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1690', '1', '2', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1691', '1', '15', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1692', '1', '16', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1693', '1', '17', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1694', '1', '18', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1695', '1', '3', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1696', '1', '19', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1697', '1', '20', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1698', '1', '21', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1699', '1', '22', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1700', '1', '4', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1701', '1', '23', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1702', '1', '24', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1703', '1', '25', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1704', '1', '26', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1705', '1', '60', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1706', '1', '61', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1707', '1', '62', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1708', '1', '63', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1709', '1', '64', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1710', '1', '65', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1711', '1', '66', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1712', '1', '67', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1713', '1', '68', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1714', '1', '69', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1715', '1', '70', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1716', '1', '34', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1717', '1', '48', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1718', '1', '49', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1719', '1', '50', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1720', '1', '51', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1721', '1', '52', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1722', '1', '53', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1723', '1', '54', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1724', '1', '55', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1725', '1', '93', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1726', '1', '94', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1727', '1', '95', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1728', '1', '96', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1729', '1', '29', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1730', '1', '81', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1731', '1', '82', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1732', '1', '83', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1733', '1', '84', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1734', '1', '85', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1735', '1', '86', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1736', '1', '87', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1737', '1', '88', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1738', '1', '89', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1739', '1', '90', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1740', '1', '91', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1741', '1', '92', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1972', '1', '102', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1973', '1', '103', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1974', '1', '104', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1975', '25', '32', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1976', '25', '104', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1977', '25', '81', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1978', '25', '82', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1979', '25', '83', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1980', '25', '84', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1981', '25', '85', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1982', '25', '86', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1983', '25', '87', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1984', '25', '88', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1985', '25', '89', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1986', '25', '90', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1987', '25', '91', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1988', '25', '92', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1989', '25', '1', '0', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1990', '25', '29', '0', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1991', '1', '105', '1', '0');
INSERT INTO sys_role_menu(id,role_id,menu_id,checked,del_flag) VALUES  ('1992', '1', '106', '1', '0');

-- 导入用户与角色之间关系
INSERT INTO sys_user_role(id,user_id,role_id,del_flag) VALUES ('170', '1', '1', '0');

-- 导入业务字典
INSERT INTO sys_dict(id,dict_type_id,param_key,param_value,status,order_num,remark,del_flag,del_token) VALUES ('1', '1', 'SYS_INFO', '{\"browserTitle\":\"基础开发框架\",\"sysName\":\"\\u003cspan style\\u003d\\u0027color:white;font-size:25px\\u0027\\u003e基础开发框架\\u003c/span\\u003e\",\"sysLoginName\":\"\\u003cspan style\\u003d\\u0027color:black\\u0027\\u003e基础开发框架\\u003c/span\\u003e\",\"sysLoginDesc\":\"\\u003cspan style\\u003d\\u0027color:#030303\\u0027\\u003e基于SpringBoot+Vue+ElementUI开发的前后端分离的快速开发平台，研发中心倾情打造\\u003c/span\\u003e\"}', '1', '999', '系统信息配置', '0', '0');
INSERT INTO sys_dict(id,dict_type_id,param_key,param_value,status,order_num,remark,del_flag,del_token) VALUES  ('2', '2', 'THEME_INFO', '{\"navBgColor\":\"#1890ff\",\"navTextColor\":\"#fff\",\"navHoverBgColor\":\"#2286e2\",\"sideBgColor\":\"#262626\",\"sideTextColor\":\"#fff\",\"sideActiveTextColor\":\"#1890ff\",\"sideHoverBgColor\":\"#151515\",\"contentColor\":\"#1890ff\"}', '1', '999', '系统主题配置', '0', '0');
INSERT INTO sys_dict(id,dict_type_id,param_key,param_value,status,order_num,remark,del_flag,del_token) VALUES  ('5', '3', 'root', '{\"packagePreffix\":\"root\",\"level\":\"INFO\"}', '1', '999', null, '0', '0');
INSERT INTO sys_dict(id,dict_type_id,param_key,param_value,status,order_num,remark,del_flag,del_token) VALUES  ('6', '3', 'com.ustcinfo.ishare.eip.admin', '{\"packagePreffix\":\"com.ustcinfo.ishare.eip.admin\",\"level\":\"DEBUG\"}', '1', '999', null, '0', '0');

-- 导入业务字典类型
INSERT INTO sys_dict_type(id,type,status,order_num,remark,del_flag,del_token) VALUES ('1', 'SYS_INFO', '1', '1', null, '0', '0');
INSERT INTO sys_dict_type(id,type,status,order_num,remark,del_flag,del_token) VALUES ('2', 'THEME_INFO', '1', '1', null, '0', '0');
INSERT INTO sys_dict_type(id,type,status,order_num,remark,del_flag,del_token) VALUES ('3', 'LOGGER_INFO', '1', '1', null, '0', '0');


