/*
 Navicat Premium Data Transfer

 Source Server         : My-root
 Source Server Type    : MySQL
 Source Server Version : 50719
 Source Host           : localhost
 Source Database       : eip-admin-starter

 Target Server Type    : MySQL
 Target Server Version : 50719
 File Encoding         : utf-8

 Date: 06/04/2019 10:05:04 AM
*/

SET NAMES utf8;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
--  Table structure for `schedule_job`
-- ----------------------------
DROP TABLE IF EXISTS `schedule_job`;
CREATE TABLE `schedule_job` (
  `job_id` varchar(64) NOT NULL COMMENT '任务id',
  `class_name` varchar(200) DEFAULT NULL COMMENT 'spring bean名称',
  `method_name` varchar(100) DEFAULT NULL COMMENT '方法名',
  `params` varchar(2000) DEFAULT NULL COMMENT '参数',
  `cron_expression` varchar(100) DEFAULT NULL COMMENT 'cron表达式',
  `status` tinyint(4) DEFAULT NULL COMMENT '任务状态  0：正常  1：暂停',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user_id` bigint(20) NOT NULL COMMENT '创建者ID',
  `del_flag` int DEFAULT NULL,
  PRIMARY KEY (`job_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='定时任务';

-- ----------------------------
--  Table structure for `schedule_job_log`
-- ----------------------------
DROP TABLE IF EXISTS `schedule_job_log`;
CREATE TABLE `schedule_job_log` (
  `log_id` varchar(64) NOT NULL COMMENT '任务日志id',
  `job_id` varchar(64) NOT NULL COMMENT '任务id',
  `class_name` varchar(200) DEFAULT NULL COMMENT 'spring bean名称',
  `method_name` varchar(100) DEFAULT NULL COMMENT '方法名',
  `params` varchar(2000) DEFAULT NULL COMMENT '参数',
  `status` tinyint(4) NOT NULL COMMENT '任务状态    0：成功    1：失败',
  `error` varchar(2000) DEFAULT NULL COMMENT '失败信息',
  `times` int(11) NOT NULL COMMENT '耗时(单位：毫秒)',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_user_id` varchar(64) NOT NULL COMMENT '创建者ID',
  PRIMARY KEY (`log_id`),
  KEY `job_id` (`job_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COMMENT='定时任务日志';

-- ----------------------------
--  Table structure for `sys_dict`
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict` (
  `id` varchar(64) NOT NULL,
  `dict_type_id` varchar(64) NOT NULL COMMENT '业务字典类型ID',
  `param_key` varchar(250) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT 'key',
  `param_value` varchar(2000) DEFAULT NULL COMMENT 'value',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态   0：隐藏   1：显示',
  `order_num` int(11) DEFAULT '1' COMMENT '排序',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `del_flag` int DEFAULT NULL,
  `del_token` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `param_key_unique` (`dict_type_id`,`param_key`,`del_token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统业务字典表';

-- ----------------------------
--  Records of `sys_dict`
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict` VALUES ('1', '1', 'SYS_INFO', '{\"browserTitle\":\"基础开发框架\",\"sysName\":\"\\u003cspan style\\u003d\\u0027color:white;font-size:25px\\u0027\\u003e基础开发框架\\u003c/span\\u003e\",\"sysLoginName\":\"\\u003cspan style\\u003d\\u0027color:black\\u0027\\u003e基础开发框架\\u003c/span\\u003e\",\"sysLoginDesc\":\"\\u003cspan style\\u003d\\u0027color:#030303\\u0027\\u003e基于SpringBoot+Vue+ElementUI开发的前后端分离的快速开发平台，研发中心倾情打造\\u003c/span\\u003e\"}', '1', '999', '系统信息配置', '0', '0'), ('2', '2', 'THEME_INFO', '{\"navBgColor\":\"#1890ff\",\"navTextColor\":\"#fff\",\"navHoverBgColor\":\"#2286e2\",\"sideBgColor\":\"#262626\",\"sideTextColor\":\"#fff\",\"sideActiveTextColor\":\"#1890ff\",\"sideHoverBgColor\":\"#151515\",\"contentColor\":\"#1890ff\"}', '1', '999', '系统主题配置', '0', '0'), ('5', '3', 'root', '{\"packagePreffix\":\"root\",\"level\":\"INFO\"}', '1', '999', null, '0', '0'), ('6', '3', 'com.ustcinfo.ishare.eip.admin', '{\"packagePreffix\":\"com.ustcinfo.ishare.eip.admin\",\"level\":\"DEBUG\"}', '1', '999', null, '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_dict_type`
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type` (
  `id` varchar(64) NOT NULL,
  `type` varchar(250) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '类型',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态   0：隐藏   1：显示',
  `order_num` tinyint(4) DEFAULT '1' COMMENT '排序',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `del_flag` int(11) DEFAULT NULL,
  `del_token` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`del_token`) USING BTREE COMMENT '类型唯一'
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统业务字典类型表';

-- ----------------------------
--  Records of `sys_dict_type`
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict_type` VALUES ('1', 'SYS_INFO', '1', '1', null, '0', '0'), ('2', 'THEME_INFO', '1', '1', null, '0', '0'), ('3', 'LOGGER_INFO', '1', '1', null, '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_log`
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` varchar(64) NOT NULL,
  `type` int NOT NULL COMMENT '日志类型',
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '用户名',
  `operation` varchar(50) DEFAULT NULL COMMENT '用户操作',
  `method` varchar(200) DEFAULT NULL COMMENT '请求方法',
  `params` varchar(5000) DEFAULT NULL COMMENT '请求参数',
  `time` bigint(20) NOT NULL COMMENT '执行时长(毫秒)',
  `ip` varchar(64) DEFAULT NULL COMMENT 'IP地址',
  `request_uri` varchar(100) DEFAULT NULL COMMENT '请求地址',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `user_id` varchar(64) DEFAULT NULL COMMENT '用户ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统日志';

-- ----------------------------
--  Table structure for `sys_menu`
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `menu_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL COMMENT '父菜单ID，一级菜单为0',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '菜单名称',
  `url` varchar(200) DEFAULT NULL COMMENT '菜单URL',
  `perms` varchar(500) DEFAULT NULL COMMENT '授权(多个用逗号分隔，如：user:list,user:create)',
  `type` int(11) DEFAULT NULL COMMENT '类型   0：目录   1：菜单   2：按钮',
  `icon` varchar(50) DEFAULT NULL COMMENT '菜单图标',
  `order_num` int(11) DEFAULT NULL COMMENT '排序',
  `status` int(11) DEFAULT NULL,
  `del_flag` int(11) DEFAULT NULL,
  `del_token` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`menu_id`),
  UNIQUE KEY `menu_nmae_unique` (`parent_id`,`name`,`del_token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='菜单管理';

-- ----------------------------
--  Records of `sys_menu`
-- ----------------------------
BEGIN;
INSERT INTO `sys_menu` VALUES ('1', '0', '系统管理', null, null, '0', 'system', '100', '1', '0', '0'), ('2', '1', '用户管理', 'basic/sys/user', null, '1', 'admin', '200', '1', '0', '0'), ('200', '1', '在线用户', 'basic/sys/online-user', null, '1', 'admin', '500', '1', '0', '0'),('3', '1', '角色管理', 'basic/sys/role', null, '1', 'role', '250', '1', '0', '0'), ('4', '1', '菜单管理', 'basic/sys/menu', null, '1', 'menu', '300', '1', '0', '0'), ('15', '2', '查看', null, 'sys:user:list,sys:user:info', '2', null, '0', '1', '0', '0'), ('16', '2', '新增', null, 'sys:user:save,sys:role:select', '2', null, '0', '1', '0', '0'), ('17', '2', '修改', null, 'sys:user:update,sys:role:select', '2', null, '0', '1', '0', '0'), ('18', '2', '删除', null, 'sys:user:delete', '2', null, '0', '1', '0', '0'), ('19', '3', '查看', null, 'sys:role:list,sys:role:info', '2', null, '0', '1', '0', '0'), ('20', '3', '新增', null, 'sys:role:save,sys:menu:list', '2', null, '0', '1', '0', '0'), ('21', '3', '修改', null, 'sys:role:update,sys:menu:list', '2', null, '0', '1', '0', '0'), ('22', '3', '删除', null, 'sys:role:delete', '2', null, '0', '1', '0', '0'), ('23', '4', '查看', null, 'sys:menu:list,sys:menu:info', '2', null, '0', '1', '0', '0'), ('24', '4', '新增', null, 'sys:menu:save,sys:menu:select', '2', null, '0', '1', '0', '0'), ('25', '4', '修改', null, 'sys:menu:update,sys:menu:select', '2', null, '0', '1', '0', '0'), ('26', '4', '删除', null, 'sys:menu:delete', '2', null, '0', '1', '0', '0'), ('29', '1', '系统日志', 'basic/sys/log', '', '1', 'log', '450', '1', '0', '0'), ('32', '1', '首页', 'basic/examples/echarts/index', null, '1', 'shouye', '150', '1', '0', '0'), ('34', '1', '基础设置', 'basic/sys/setting', null, '1', 'system', '400', '1', '0', '0'), ('48', '34', 'logo查看', null, 'sys:logo:view', '2', null, '0', '1', '0', '0'), ('49', '34', 'logo删除', null, 'sys:logo:delete', '2', null, '0', '1', '0', '0'), ('50', '34', 'logo激活', null, 'sys:logo:edit', '2', null, '0', '1', '0', '0'), ('51', '34', 'logo默认获取', null, 'sys:logo:view', '2', null, '0', '1', '0', '0'), ('52', '34', '背景图片查看', null, 'sys:bg:view', '2', null, '0', '1', '0', '0'), ('53', '34', '背景图上传', null, 'sys:bg:edit', '2', null, '0', '1', '0', '0'), ('54', '34', '背景图片删除', null, 'sys:bg:delete', '2', null, '0', '1', '0', '0'), ('55', '34', '系统信息修改', null, 'sys:info:edit', '2', null, '0', '1', '0', '0'), ('60', '1', '字典管理', 'basic/sys/dict', null, '1', 'bianji', '350', '1', '0', '0'), ('61', '60', '类型添加', null, 'sys:dict_type:save', '2', null, '0', '1', '0', '0'), ('62', '60', '类型修改', null, 'sys:dict_type:update', '2', null, '0', '1', '0', '0'), ('63', '60', '类型获取', null, 'sys:dict_type:select', '2', null, '0', '1', '0', '0'), ('64', '60', '类型详情', null, 'sys:dict_type:info', '2', null, '0', '1', '0', '0'), ('65', '60', '类型删除', null, 'sys:dict_type:delete', '2', null, '0', '1', '0', '0'), ('66', '60', '字典获取', null, 'sys:dict:list', '2', null, '0', '1', '0', '0'), ('67', '60', '字典详情', null, 'sys:dict:info', '2', null, '0', '1', '0', '0'), ('68', '60', '字典添加', null, 'sys:dict:save', '2', null, '0', '1', '0', '0'), ('69', '60', '字典修改', null, 'sys:dict:update', '2', null, '0', '1', '0', '0'), ('70', '60', '字典删除', null, 'sys:dict:delete', '2', null, '0', '1', '0', '0'), ('81', '0', '其他', null, null, '0', 'zonghe', '1000', '1', '0', '0'), ('82', '81', '定时任务', 'basic/quartz/quartz', null, '1', 'job', '1100', '1', '0', '0'), ('83', '82', '查看', null, 'sys:schedule:list', '2', null, '0', '1', '0', '0'), ('84', '82', '详情', null, 'sys:schedule:info', '2', null, '0', '1', '0', '0'), ('85', '82', '新增', null, 'sys:schedule:save', '2', null, '0', '1', '0', '0'), ('86', '82', '修改', null, 'sys:schedule:update', '2', null, '0', '1', '0', '0'), ('87', '82', '删除', null, 'sys:schedule:delete', '2', null, '0', '1', '0', '0'), ('88', '82', '执行', null, 'sys:schedule:run', '2', null, '0', '1', '0', '0'), ('89', '82', '暂停', null, 'sys:schedule:pause', '2', null, '0', '1', '0', '0'), ('90', '82', '恢复', null, 'sys:schedule:resume', '2', null, '0', '1', '0', '0'), ('91', '82', '查看日志', null, 'sys:schedule:log', '2', null, '0', '1', '0', '0'), ('92', '81', 'SQL监控', 'http://localhost:8081/eip-admin-rest/druid/sql.html', null, '1', 'sql', '1200', '1', '0', '0'), ('93', '34', '网站图标查看', null, 'sys:favicon:view', '2', null, '0', '1', '0', '0'), ('94', '34', '网站图标上传', null, 'sys:favicon:edit', '2', null, '0', '1', '0', '0'), ('95', '34', '网站图标删除', null, 'sys:favicon:delete', '2', null, '0', '1', '0', '0'), ('96', '34', '网站图标切换', null, 'sys:favicon:edit', '2', null, '0', '1', '0', '0'), ('102', '29', '日志级别查看', '', 'sys:logger:view', '2', '', '0', '1', '0', '0'), ('103', '29', '日志级别修改', '', 'sys:logger:edit', '2', '', '0', '1', '0', '0'), ('104', '29', '日志查看', '', 'sys:log:list', '2', '', '0', '1', '0', '0'), ('105', '2', '禁用用户', '', 'sys:user:lock', '2', '', '0', '1', '0', '0'), ('106', '2', '解锁用户', '', 'sys:user:unlock', '2', '', '0', '1', '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_role`
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `role_id`   varchar(64) NOT NULL,
  `role_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '角色名称',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `del_flag` int(11) DEFAULT NULL,
  `del_token` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`,`del_token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色';

-- ----------------------------
--  Records of `sys_role`
-- ----------------------------
BEGIN;
INSERT INTO `sys_role` VALUES ('1', '系统管理员', '', '2019-04-15 11:13:58', '0', '0'), ('25', '普通用户', '', '2019-04-15 11:38:53', '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_role_menu`
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `id` varchar(64) NOT NULL,
  `role_id` varchar(64) DEFAULT NULL COMMENT '角色ID',
  `menu_id` varchar(64) DEFAULT NULL COMMENT '菜单ID',
  `checked` int(11) DEFAULT NULL,
  `del_flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1993 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色与菜单对应关系';

-- ----------------------------
--  Records of `sys_role_menu`
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_menu` VALUES ('1688', '1', '1', '1', '0'), ('1689', '1', '32', '1', '0'), ('1690', '1', '2', '1', '0'), ('1691', '1', '15', '1', '0'), ('1692', '1', '16', '1', '0'), ('1693', '1', '17', '1', '0'), ('1694', '1', '18', '1', '0'), ('1695', '1', '3', '1', '0'), ('1696', '1', '19', '1', '0'), ('1697', '1', '20', '1', '0'), ('1698', '1', '21', '1', '0'), ('1699', '1', '22', '1', '0'), ('1700', '1', '4', '1', '0'), ('1701', '1', '23', '1', '0'), ('1702', '1', '24', '1', '0'), ('1703', '1', '25', '1', '0'), ('1704', '1', '26', '1', '0'), ('1705', '1', '60', '1', '0'), ('1706', '1', '61', '1', '0'), ('1707', '1', '62', '1', '0'), ('1708', '1', '63', '1', '0'), ('1709', '1', '64', '1', '0'), ('1710', '1', '65', '1', '0'), ('1711', '1', '66', '1', '0'), ('1712', '1', '67', '1', '0'), ('1713', '1', '68', '1', '0'), ('1714', '1', '69', '1', '0'), ('1715', '1', '70', '1', '0'), ('1716', '1', '34', '1', '0'), ('1717', '1', '48', '1', '0'), ('1718', '1', '49', '1', '0'), ('1719', '1', '50', '1', '0'), ('1720', '1', '51', '1', '0'), ('1721', '1', '52', '1', '0'), ('1722', '1', '53', '1', '0'), ('1723', '1', '54', '1', '0'), ('1724', '1', '55', '1', '0'), ('1725', '1', '93', '1', '0'), ('1726', '1', '94', '1', '0'), ('1727', '1', '95', '1', '0'), ('1728', '1', '96', '1', '0'), ('1729', '1', '29', '1', '0'), ('1730', '1', '81', '1', '0'), ('1731', '1', '82', '1', '0'), ('1732', '1', '83', '1', '0'), ('1733', '1', '84', '1', '0'), ('1734', '1', '85', '1', '0'), ('1735', '1', '86', '1', '0'), ('1736', '1', '87', '1', '0'), ('1737', '1', '88', '1', '0'), ('1738', '1', '89', '1', '0'), ('1739', '1', '90', '1', '0'), ('1740', '1', '91', '1', '0'), ('1741', '1', '92', '1', '0'), ('1972', '1', '102', '1', '0'), ('1973', '1', '103', '1', '0'), ('1974', '1', '104', '1', '0'), ('1975', '25', '32', '1', '0'), ('1976', '25', '104', '1', '0'), ('1977', '25', '81', '1', '0'), ('1978', '25', '82', '1', '0'), ('1979', '25', '83', '1', '0'), ('1980', '25', '84', '1', '0'), ('1981', '25', '85', '1', '0'), ('1982', '25', '86', '1', '0'), ('1983', '25', '87', '1', '0'), ('1984', '25', '88', '1', '0'), ('1985', '25', '89', '1', '0'), ('1986', '25', '90', '1', '0'), ('1987', '25', '91', '1', '0'), ('1988', '25', '92', '1', '0'), ('1989', '25', '1', '0', '0'), ('1990', '25', '29', '0', '0'), ('1991', '1', '105', '1', '0'), ('1992', '1', '106', '1', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_user`
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `user_id` varchar(64) NOT NULL,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '用户名',
  `password` varchar(100) DEFAULT NULL COMMENT '密码',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `mobile` varchar(100) DEFAULT NULL COMMENT '手机号',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态  0：禁用   1：正常',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `del_flag` int(11) DEFAULT NULL,
  `del_token` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`,`del_token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统用户';

-- ----------------------------
--  Records of `sys_user`
-- ----------------------------
BEGIN;
INSERT INTO `sys_user` VALUES ('1', 'admin', 'e2b3678e8af69ade303325a17c7f9059bfcdf054c20cf899279df60afcd783c3', '', '', '1', '2018-11-11 11:11:11', '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `sys_user_role`
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) DEFAULT NULL COMMENT '用户ID',
  `role_id` varchar(64) DEFAULT NULL COMMENT '角色ID',
  `del_flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户与角色对应关系';

-- ----------------------------
--  Records of `sys_user_role`
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_role` VALUES ('170', '1', '1', '0');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
