package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.google.gson.Gson;
import com.ustcinfo.ishare.eip.admin.common.constant.Dict;
import com.ustcinfo.ishare.eip.admin.common.constant.DictType;
import com.ustcinfo.ishare.eip.admin.common.validator.ValidatorUtils;
import com.ustcinfo.ishare.eip.admin.common.validator.group.AddGroup;
import com.ustcinfo.ishare.eip.admin.common.validator.group.UpdateGroup;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysDictEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysDictTypeEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysDictForm;
import com.ustcinfo.ishare.eip.admin.service.sys.form.ThemeForm;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictService;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 控制主题
 */
@RestController
@RequestMapping("/theme")
@Api(tags = "皮肤管理")
public class SysThemeController extends AbstractController {

    @Autowired
    private SysDictService dictService;
    @Autowired
    private SysDictTypeService dictTypeService;


    @PostMapping("/update")
    @ApiOperation(value = "更新系统皮肤", notes = "更新系统皮肤", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> update(@ApiParam(name = "系统皮肤对象", value = "传入json格式", required = true) @RequestBody ThemeForm info) {
        ValidatorUtils.validateEntity(info, AddGroup.class, UpdateGroup.class);
        String value = new Gson().toJson(info);
        SysDictTypeEntity dictTypeEntity = dictTypeService.queryByType(DictType.THEME_INFO);
        if (dictTypeEntity == null) {
            dictTypeEntity = new SysDictTypeEntity(DictType.THEME_INFO);
            dictTypeService.save(dictTypeEntity);
        }
        SysDictEntity config = dictService.queryOneByDictType(DictType.THEME_INFO);
        if (config == null) {
            config = new SysDictEntity( null, dictTypeEntity.getId(), Dict.THEME_INFO, value, "系统主题配置", 999);
            dictService.add(new SysDictForm(config));
        }
        config.setParamValue(value);
        dictService.update(new SysDictForm(config));
        return JsonResult.ok();
    }
}
