package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.common.validator.ValidatorUtils;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.annotation.SysLog;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysRoleEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysRoleMenuEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.page.PageUtils;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysRoleMenuService;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysRoleService;
import com.ustcinfo.ishare.eip.admin.service.sys.utils.UserUtils;
import io.swagger.annotations.*;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;
import java.util.Map;

/**
 * 角色管理
 */
@RestController
@RequestMapping("/sys/role")
@Api(tags = "角色管理")
public class SysRoleController extends AbstractController {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;

    /**
     * 角色列表
     */
    @GetMapping("/list")
    @RequiresPermissions("sys:role:list")
    @ApiOperation(value = "列表", notes = "分页查询角色列表", produces = MediaType.APPLICATION_JSON_VALUE)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "page", value = "页码", paramType = "query", required = true, dataType = "int"),
            @ApiImplicitParam(name = "limit", value = "每页条数", paramType = "query", required = true, dataType = "int"),
            @ApiImplicitParam(name = "sidx", value = "排序字段", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "order", value = "排序方式，如：asc、desc", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "searchKey", value = "角色名", paramType = "query", dataType = "string")
    })
    public JsonResult<PageUtils<SysRoleEntity>> list(@ApiIgnore @RequestParam Map<String, Object> params) {
        PageUtils page = sysRoleService.queryPage(params);
        return JsonResult.ok().put(page);
    }

    /**
     * 角色列表
     */
    @GetMapping("/select")
    @RequiresPermissions("sys:role:select")
    @ApiOperation(value = "当前账号角色列表", notes = "查询当前账号角色列表", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<SysRoleEntity>> select() {
        String userid = null;
        if (UserUtils.isNotAdmin()) {
            userid = getUserId();
        }
        List<SysRoleEntity> list = sysRoleService.queryRoleList(userid);
        return JsonResult.ok().put(list);
    }

    /**
     * 角色信息
     */
    @GetMapping("/info/{roleId}")
    @RequiresPermissions("sys:role:info")
    @ApiOperation(value = "详情", notes = "查询指定角色详细信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<SysRoleEntity> info(@PathVariable("roleId") String roleId) {
        SysRoleEntity role = sysRoleService.getById(roleId);
        //查询角色对应的菜单
        List<String> menuIdList = sysRoleMenuService.queryMenuIdList(roleId);
        List<SysRoleMenuEntity> roleMenuList = sysRoleMenuService.queryByRoleId(roleId);
        role.setRoleMenuList(roleMenuList);
        role.setMenuIdList(menuIdList);
        return JsonResult.ok().put(role);
    }

    /**
     * 保存角色
     */
    @SysLog("保存角色")
    @PostMapping("/save")
    @RequiresPermissions("sys:role:save")
    @ApiOperation(value = "添加", notes = "添加角色", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> save(@ApiParam(name = "添加角色对象", value = "传入json格式", required = true) @RequestBody SysRoleEntity role) {
        ValidatorUtils.validateEntity(role);
        sysRoleService.add(role);
        return JsonResult.ok();
    }

    /**
     * 修改角色
     */
    @SysLog("修改角色")
    @PostMapping("/update")
    @RequiresPermissions("sys:role:update")
    @ApiOperation(value = "修改", notes = "修改角色", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> update(@ApiParam(name = "修改角色对象", value = "传入json格式", required = true) @RequestBody SysRoleEntity role) {
        ValidatorUtils.validateEntity(role);
        sysRoleService.update(role);
        return JsonResult.ok();
    }

    /**
     * 删除角色
     */
    @SysLog("删除角色")
    @PostMapping("/delete")
    @RequiresPermissions("sys:role:delete")
    @ApiOperation(value = "删除", notes = "删除角色", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> delete(@RequestBody String[] roleIds) {
        sysRoleService.deleteBatch(roleIds);

        return JsonResult.ok();
    }
}
