package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.common.constant.SYS_FILE_TYPE;
import com.ustcinfo.ishare.eip.admin.common.exception.EIPException;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysFileForm;
import com.ustcinfo.ishare.eip.admin.service.sys.utils.StaticResouceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

/**
 * 系统Logo管理
 */
@RestController
@RequestMapping("/sys/logo")
@Api(tags = "系统LOGO")
public class SysLogoController extends AbstractController {

    @Autowired
    private StaticResouceUtils staticResouceUtils;

    /**
     * logo列表
     *
     * @return
     */
    @GetMapping("/list")
    @RequiresPermissions("sys:logo:view")
    @ApiOperation(value = "列表", notes = "查询所有logo", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<String>> getLogoList() {
        List<String> list = staticResouceUtils.fileNameList(SYS_FILE_TYPE.SYS_LOGO);
        return JsonResult.ok().put(list);
    }

    /**
     * 系统logo图标上传
     */
    @RequiresPermissions("sys:logo:edit")
    @PostMapping("/upload")
    @ApiOperation(value = "上传", notes = "上传logo", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> upload(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new EIPException("上传文件不能为空");
        }
        String originalFilename = file.getOriginalFilename();
        if (!FilenameUtils.getExtension(originalFilename).equals(SYS_FILE_TYPE.SYS_LOGO.getActiveFileSuffix())) {
            throw new EIPException(String.format("只支持%s格式的图片！", SYS_FILE_TYPE.SYS_LOGO.getActiveFileSuffix()));
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        int width = image.getWidth();
        int height = image.getHeight();
        if (width > 400 || height > 100) {
            return JsonResult.error("请上传40*230格式的logo");
        }
        staticResouceUtils.uploadFile(SYS_FILE_TYPE.SYS_LOGO, image, originalFilename);
        return JsonResult.ok();
    }

    /**
     * 系统logo删除
     *
     * @param fileForms
     * @return
     */
    @PostMapping("/delete")
    @RequiresPermissions("sys:logo:delete")
    @ApiOperation(value = "删除", notes = "删除logo", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> delLogo(@RequestBody SysFileForm[] fileForms) {
        staticResouceUtils.deleteFile(SYS_FILE_TYPE.SYS_LOGO, fileForms);
        return JsonResult.ok();
    }

    /**
     * 系统logo切换
     *
     * @param fileForm
     * @return
     */
    @RequiresPermissions("sys:logo:edit")
    @PostMapping("/toggle")
    @ApiOperation(value = "切换", notes = "切换logo", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> toggleLogo(@RequestBody SysFileForm fileForm) throws IOException {
        staticResouceUtils.toggleFile(SYS_FILE_TYPE.SYS_LOGO, fileForm);
        return JsonResult.ok();
    }
}
