package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.LoggerForm;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysLoggerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 系统日志级别调整
 */
@RestController
@RequestMapping("/sys/logger")
@Api(tags = "日志级别", hidden = true)
public class SysLoggerController extends AbstractController {

    @Autowired
    private SysLoggerService sysLoggerService;

    @PostMapping("/level/save")
    @RequiresPermissions("sys:logger:edit")
    @ApiOperation(value = "修改", notes = "修改日志级别", produces = MediaType.IMAGE_JPEG_VALUE)
    public JsonResult<Void> updateLoggerLevel(@RequestBody List<LoggerForm> loggerList) {
        sysLoggerService.update(loggerList);
        return JsonResult.ok();
    }

    @GetMapping("/level/list")
    @RequiresPermissions("sys:logger:view")
    @ApiOperation(value = "获取日志级别信息", notes = "获取日志级别信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<LoggerForm>> getLoggerLevel() {
        List<LoggerForm> list = sysLoggerService.queryList();
        return JsonResult.ok().put(list);
    }

}
