package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysLogEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.page.PageUtils;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

import java.util.Map;


/**
 * 系统日志
 */
@Controller
@RequestMapping("/sys/log")
@Api(tags = "系统日志")
public class SysLogController extends AbstractController {
    @Autowired
    private SysLogService sysLogService;

    /**
     * 列表
     */
    @ResponseBody
    @GetMapping("/list")
    @RequiresPermissions("sys:log:list")
    @ApiOperation(value = "列表", notes = "分页查询系统日志列表", produces = MediaType.APPLICATION_JSON_VALUE)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "page", value = "页码", paramType = "query", required = true, dataType = "int"),
            @ApiImplicitParam(name = "limit", value = "每页条数", paramType = "query", required = true, dataType = "int"),
            @ApiImplicitParam(name = "sidx", value = "排序字段", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "order", value = "排序方式，如：asc、desc", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "searchKey", value = "用户名或用户操作", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "startTime", value = "开始时间(yyyy-MM-dd HH:mm)", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "endTime", value = "结束时间(yyyy-MM-dd HH:mm)", paramType = "query", dataType = "string")
    })
    public JsonResult<PageUtils<SysLogEntity>> list(@ApiIgnore @RequestParam Map<String, Object> params) {
        PageUtils page = sysLogService.queryPage(params);
        return JsonResult.ok().put(page);
    }

}
