package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustcinfo.ishare.eip.admin.common.constant.Dict;
import com.ustcinfo.ishare.eip.admin.common.constant.DictType;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysDictEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysDictTypeEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysDictForm;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysInfoForm;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictService;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统信息
 */
@RestController
@RequestMapping("/sys/info")
@Api(tags = "系统信息")
public class SysInfoController extends AbstractController {
    @Autowired
    private SysDictService dictService;
    @Autowired
    private SysDictTypeService dictTypeService;

    /**
     * 保存系统信息
     *
     * @param info
     * @return
     */
    @PostMapping("/save")
    @RequiresPermissions("sys:info:edit")
    @ApiOperation(value = "保存", notes = "保存系统信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> sysInfoSave(@ApiParam(name = "系统配置对象", value = "传入json格式", required = true) @RequestBody SysInfoForm info) throws Exception {

        SysDictTypeEntity dictTypeEntity = dictTypeService.queryByType(DictType.SYS_INFO);
        if (dictTypeEntity == null) {
            dictTypeEntity = new SysDictTypeEntity(DictType.SYS_INFO);
            dictTypeService.save(dictTypeEntity);
        }
        SysDictEntity dictEntity = dictService.queryOneByDictType(DictType.SYS_INFO);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String value = gson.toJson(info);
        if (dictEntity == null) {
            dictEntity = new SysDictEntity(null, dictTypeEntity.getId(), Dict.SYS_INFO, value, "系统基础信息配置", 998);
            dictService.add(new SysDictForm(dictEntity));
            return JsonResult.ok();
        }
        dictEntity.setParamValue(value);
        dictService.update(new SysDictForm(dictEntity));
        return JsonResult.ok();
    }
}
