package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.common.constant.SYS_FILE_TYPE;
import com.ustcinfo.ishare.eip.admin.common.exception.EIPException;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysFileForm;
import com.ustcinfo.ishare.eip.admin.service.sys.utils.StaticResouceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 浏览器网页标题前的图标
 */
@RestController
@RequestMapping("/sys/favicon")
@Api(tags = "网站图标")
public class SysFaviconController extends AbstractController {

    @Autowired
    private StaticResouceUtils staticResouceUtils;

    @GetMapping("/list")
    @RequiresPermissions("sys:favicon:view")
    @ApiOperation(value = "列表", notes = "查询所有favicon名称", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<String>> nameList() {
        List<String> list = staticResouceUtils.fileNameList(SYS_FILE_TYPE.SYS_FAVICON);
        return JsonResult.ok().put(list);
    }

    @RequiresPermissions("sys:favicon:edit")
    @PostMapping("/upload")
    @ApiOperation(value = "上传", notes = "上传favicon", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> upload(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new EIPException("上传文件不能为空");
        }
        String filename = file.getOriginalFilename();
        if (!SYS_FILE_TYPE.SYS_FAVICON.getActiveFileSuffix().equals(FilenameUtils.getExtension(filename))) {
            throw new EIPException(String.format("只支持%s格式的网站图标！", SYS_FILE_TYPE.SYS_FAVICON.getActiveFileSuffix()));
        }
        // 获取文件后缀名
        File logoDirFile = new File(staticResouceUtils.getFilePath(SYS_FILE_TYPE.SYS_FAVICON));
        if (!logoDirFile.exists()) {
            logoDirFile.mkdirs();
        }
        FileUtils.copyToFile(file.getInputStream(), new File(staticResouceUtils.getFilePath(SYS_FILE_TYPE.SYS_FAVICON) + File.separator + filename));
        return JsonResult.ok();
    }

    @PostMapping("/delete")
    @RequiresPermissions("sys:favicon:delete")
    @ApiOperation(value = "删除", notes = "删除favicon", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> delLogo(@RequestBody SysFileForm[] fileForms) {
        staticResouceUtils.deleteFile(SYS_FILE_TYPE.SYS_FAVICON, fileForms);
        return JsonResult.ok();
    }

    @RequiresPermissions("sys:favicon:edit")
    @PostMapping("/toggle")
    @ApiOperation(value = "切换", notes = "切换favicon", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> toggleLogo(@RequestBody SysFileForm fileForm) throws IOException {
        staticResouceUtils.toggleFile(SYS_FILE_TYPE.SYS_FAVICON, fileForm);
        return JsonResult.ok();
    }
}
