package com.ustcinfo.ishare.eip.admin.rest.sys.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ustcinfo.ishare.eip.admin.common.validator.ValidatorUtils;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.annotation.SysLog;
import com.ustcinfo.ishare.eip.admin.service.sys.entity.SysDictTypeEntity;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 业务字典类型
 */
@RestController
@RequestMapping("/sys/dict/type")
@Api(tags = "业务字典类型")
public class SysDictTypeController extends AbstractController {

    @Autowired
    private SysDictTypeService dictTypeService;

    @GetMapping("/select")
    @RequiresPermissions("sys:dict_type:select")
    @ApiOperation(value = "选择业务字典类型", notes = "展示所有的业务字典类型", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<SysDictTypeEntity>> select() {
        List<SysDictTypeEntity> list = dictTypeService.list(new QueryWrapper<SysDictTypeEntity>().orderByAsc("type"));
        return JsonResult.ok().put(list);
    }

    @GetMapping("/info/{id}")
    @RequiresPermissions("sys:dict_type:info")
    @ApiOperation(value = "详情", notes = "获取指定类型的详细信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<SysDictTypeEntity> info(@PathVariable("id") String id) {
        SysDictTypeEntity dictTypeEntity = dictTypeService.getById(id);
        return JsonResult.ok().put(dictTypeEntity);
    }

    @SysLog("保存业务字典类型")
    @PostMapping("/save")
    @RequiresPermissions("sys:dict_type:save")
    @ApiOperation(value = "添加", notes = "添加业务字典类型信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> save(@ApiParam(name = "添加业务字典类型对象", value = "传入json格式", required = true) @RequestBody SysDictTypeEntity dictType) {
        ValidatorUtils.validateEntity(dictType);
        dictTypeService.add(dictType);
        return JsonResult.ok();
    }

    @SysLog("修改业务字典类型")
    @PostMapping("/update")
    @RequiresPermissions("sys:dict_type:update")
    @ApiOperation(value = "修改", notes = "修改业务字典类型信息", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> update(@ApiParam(name = "修改业务字典类型对象", value = "传入json格式", required = true) @RequestBody SysDictTypeEntity dictType) {
        ValidatorUtils.validateEntity(dictType);
        dictTypeService.update(dictType);
        return JsonResult.ok();
    }

    @SysLog("删除业务字典类型")
    @PostMapping("/delete")
    @RequiresPermissions("sys:dict_type:delete")
    @ApiOperation(value = "删除", notes = "删除业务字典类型对象", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> delete(@RequestBody String[] ids) {
        dictTypeService.deleteBatch(ids);
        return JsonResult.ok();
    }

}
