package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.common.constant.SYS_FILE_TYPE;
import com.ustcinfo.ishare.eip.admin.common.exception.EIPException;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysFileForm;
import com.ustcinfo.ishare.eip.admin.service.sys.utils.StaticResouceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

/**
 * 系统的背景图管理
 */
@RestController
@RequestMapping("/sys/bg")
@Api(tags = "系统背景管理")
public class SysBgController extends AbstractController {

    @Autowired
    private StaticResouceUtils staticResouceUtils;

    /**
     * 获取所有的背景图
     */
    @GetMapping("/list")
    @RequiresPermissions("sys:bg:view")
    @ApiOperation(value = "列表", notes = "查询所有背景图", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<List<String>> getBgList() {
        List<String> list = staticResouceUtils.fileNameList(SYS_FILE_TYPE.SYS_BG);
        return JsonResult.ok().put(list);
    }

    /**
     * 系统背景上传
     */
    @PostMapping("/upload")
    @RequiresPermissions("sys:bg:edit")
    @ApiOperation(value = "上传", notes = "上传系统背景图", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> upload(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new EIPException("上传文件不能为空");
        }
        String filename = file.getOriginalFilename();
        if (!SYS_FILE_TYPE.SYS_BG.getActiveFileSuffix().equals(FilenameUtils.getExtension(filename))) {
            throw new EIPException(String.format("只支持%s格式的图片！", SYS_FILE_TYPE.SYS_BG.getActiveFileSuffix()));
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        staticResouceUtils.uploadFile(SYS_FILE_TYPE.SYS_BG, image, filename);
        return JsonResult.ok();
    }

    /**
     * 删除
     *
     * @param fileForms
     * @return
     */
    @PostMapping("/delete")
    @RequiresPermissions("sys:bg:delete")
    @ApiOperation(value = "删除", notes = "删除系统背景图", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> delLogo(@RequestBody SysFileForm[] fileForms) {
        staticResouceUtils.deleteFile(SYS_FILE_TYPE.SYS_BG, fileForms);
        return JsonResult.ok();
    }

    /**
     * 切换背景
     *
     * @param fileForm
     * @return
     */
    @RequiresPermissions("sys:bg:edit")
    @PostMapping("/toggle")
    @ApiOperation(value = "切换", notes = "切换系统背景图", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<Void> toggleLogo(@RequestBody SysFileForm fileForm) throws IOException {
        staticResouceUtils.toggleFile(SYS_FILE_TYPE.SYS_BG, fileForm);
        return JsonResult.ok();
    }
}
