package com.ustcinfo.ishare.eip.admin.rest.sys.controller;

import com.ustcinfo.ishare.eip.admin.common.constant.DictType;
import com.ustcinfo.ishare.eip.admin.common.utils.ThemeUtils;
import com.ustcinfo.ishare.eip.admin.controller.AbstractController;
import com.ustcinfo.ishare.eip.admin.service.sys.form.JsonResult;
import com.ustcinfo.ishare.eip.admin.service.sys.form.SysInfoForm;
import com.ustcinfo.ishare.eip.admin.service.sys.form.ThemeForm;
import com.ustcinfo.ishare.eip.admin.service.sys.service.SysDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 基础框架开放的接口
 * 用于获取系统基础信息
 * 修改的接口必须经过权限验证（开放-关闭原则）
 */
@RestController
@RequestMapping("/api")
@Api(tags = "开放接口")
public class ApiController extends AbstractController {
    @Autowired
    private SysDictService dictService;

    /**
     * 获取系统信息
     *
     * @return
     */
    @GetMapping("/sys/info")
    @ApiOperation(value = "获取系统基础设置", notes = "获取系统基础设置", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<SysInfoForm> getSysInfo() {
        SysInfoForm info = dictService.queryOneByDictType(DictType.SYS_INFO, SysInfoForm.class);
        if (info == null) {
            info = new SysInfoForm();
            info.setBrowserTitle("基础开发框架");
            info.setSysName("基础开发框架");
            info.setSysLoginName("基础开发框架");
            info.setSysLoginDesc("基于SpringBoot+Vue+ElementUI开发的前后端分离的快速开发平台，研发中心倾情打造");
            info.setTabOpen(true);
        }
        return JsonResult.ok().put(info);
    }

    @GetMapping("/theme/info")
    @ApiOperation(value = "获取系统皮肤", notes = "获取皮肤详情", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<ThemeForm> skinInfo() {
        ThemeForm info = dictService.queryOneByDictType(DictType.THEME_INFO, ThemeForm.class);
        if (info == null) {
            info = new ThemeForm();
            info.setNavBgColor("#3373d3");
            info.setNavTextColor("#fff");
            info.setNavHoverBgColor("#2d64b7");
            info.setSideBgColor("#262626");
            info.setSideTextColor("#fff");
            info.setSideActiveTextColor("#3373d3");
            info.setSideHoverBgColor("#151515");
            info.setContentColor("#3373d3");
        }
        return JsonResult.ok().put(info);
    }

    @GetMapping("/static/admin/css")
    @ApiOperation(value = "获取系统css", notes = "获取系统css，解决动态主题问题", produces = MediaType.APPLICATION_JSON_VALUE)
    public JsonResult<String> adminCss() {
        ThemeForm info = dictService.queryOneByDictType(DictType.THEME_INFO, ThemeForm.class);
        if (info == null) {
            info = new ThemeForm();
        }
        String css = ThemeUtils.changeTheme(null, info.getContentColor());
        // 替换css
        css = css.replaceAll("navBgColor", info.getNavBgColor());
        css = css.replaceAll("navHoverBgColor", info.getNavHoverBgColor());
        css = css.replaceAll("navTextColor", info.getNavTextColor());

        css = css.replaceAll("sideHoverBgColor", info.getSideHoverBgColor());
        css = css.replaceAll("sideBgColor", info.getSideBgColor());
        css = css.replaceAll("sideTextColor", info.getSideTextColor());
        css = css.replaceAll("sideActiveTextColor", info.getSideActiveTextColor());
        css = css.replaceAll("sideHoverBgColor", info.getSideHoverBgColor());

        css = css.replaceAll("contentColor", info.getContentColor());

        return JsonResult.ok().put(css);
    }
}
