package com.ustcinfo.ishare.eip.admin.cache.memory;

import com.ustcinfo.ishare.eip.admin.cache.common.AdminCacheable;
import com.ustcinfo.ishare.eip.admin.cache.common.AdminTimeOutCacheable;
import com.ustcinfo.ishare.eip.admin.cache.common.IAdminCache;
import com.ustcinfo.ishare.eip.admin.cache.common.Cache;
import com.ustcinfo.ishare.eip.admin.cache.common.constant.CacheConstant;
import com.ustcinfo.ishare.eip.admin.cache.common.constant.CacheGetPolicy;
import com.ustcinfo.ishare.eip.admin.cache.common.constant.CachePutPolicy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 基于内存的缓存
 *
 * @author liuchengbiao
 * @date 2019/4/22 下午2:14
 */
@Component("memoryCacheImpl")
@Slf4j
public class MemoryCacheImpl implements IAdminCache {

    @Override
    public void load(List<String> tenantList) {
        log.error("基于内存的缓存暂时未实现数据自动加载");
    }

    @Override
    public void loadAllByClass(List<Class> classList) {
        log.error("基于内存的缓存暂时未实现数据自动加载");
    }

    @Override
    public List<String> reSubscribe(List<String> tenantList) {
        log.error("基于内存的缓存暂时不支持数据订阅");
        return null;
    }

    @Override
    public void unSubscribe(List<String> tenantList) {
        log.error("基于内存的缓存暂时不支持数据取消订阅");
    }

    @Override
    public void put(AdminCacheable cache) {
        Cache.put(cache);
    }

    @Override
    public void put(AdminCacheable entity, CachePutPolicy storePolicy) {
        Cache.put(entity);
    }

    @Override
    public void put(AdminTimeOutCacheable entity, Integer timeOut, TimeUnit unit) {
        Cache.put(entity, timeOut, unit);
    }

    @Override
    public void remove(Class<?> clazz, Serializable key) {
        Cache.remove(clazz, key);
    }

    @Override
    public void remove(Class<?> clzz, Serializable tenant, Serializable key) {
        Cache.remove(clzz, tenant, key);
    }

    @Override
    public void removeAll(Class<?> clazz) {
        Cache.removeAll(clazz);
    }

    @Override
    public void removeAll(Class<?> clazz, Serializable tenant) {
        Cache.removeAll(clazz, tenant);
    }

    @Override
    public <T> T get(Class<T> clazz, Serializable key) {
        return Cache.get(clazz, key);
    }

    @Override
    public <T> T get(Class<T> clazz, Serializable tenant, Serializable key) {
        return Cache.get(clazz, tenant, key);
    }

    @Override
    public Set<Serializable> getKeySet(Class clazz, Serializable tenant, CacheGetPolicy getPolicy) {
        return Cache.getKeySet(clazz, tenant);
    }

    @Override
    public Set<Serializable> getOriginalKeySet(Class clazz, Serializable tenant, CacheGetPolicy getPolicy) {
        return Cache.getOriginalKeySet(clazz, tenant);
    }

    @Override
    public <T> T get(Class<T> clazz, Serializable tenant, Serializable key, CacheGetPolicy getPolicy) {
        return Cache.get(clazz, tenant, key);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) {
        return Cache.getAll(clazz, CacheConstant.DEFAULT_TENANT);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, Serializable tenant) {
        return Cache.getAll(clazz, tenant);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, Serializable tenant, CacheGetPolicy getPolicy) {
        return Cache.getAll(clazz, tenant);
    }
}
