package com.ustcinfo.ishare.eip.admin.cache.sys;

import com.ustcinfo.ishare.eip.admin.cache.common.AdminTimeOutCache;
import com.ustcinfo.ishare.eip.admin.cache.common.annotation.AdminCacheKey;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liuchengbiao
 * @date 2019/4/22 下午2:39
 */
@Data
@ApiModel
public class SysUserTokenCache extends AdminTimeOutCache {

    @AdminCacheKey
    @ApiModelProperty(notes = "token")
    private String token;

    @ApiModelProperty(notes = "用户ID")
    private String userId;

    @ApiModelProperty(notes = "用户名")
    private String userName;

    //更新时间
    @ApiModelProperty(notes = "更新时间")
    private Date updateTime;
    
    /**
     * 如果拿到token访问系统
     * 但不是登录的IP,那么就拒绝访问
     */
    @ApiModelProperty(notes = "登录的IP")
    private String loginIp;
}
