package com.ustcinfo.ishare.eip.admin.cache.common.constant;

/**
 * 缓存删除策略
 *
 * @author liuchengbiao
 * @date 2019-08-13 15:08
 */
public enum CacheRemovePolicy {
    INNER_ONLY(1, "仅从当前缓存中删除"),
    MIDDLE_WARE_ONLY(2, "仅从中间件缓存删除"),
    ALL(3, "当前节点缓存以及中间件缓存都删除");
    /**
     * 类型
     */
    private int type;
    /**
     * 描述
     */
    private String desc;

    CacheRemovePolicy(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
