package com.ustcinfo.ishare.eip.admin.cache.common.constant;

/**
 * 缓存存储策略
 *
 * @author liuchengbiao
 * @date 2019-08-13 15:08
 */
public enum CachePutPolicy {
    INNER_ONLY(1, "仅存当前缓存、不存储中间件中"),
    MIDDLE_WARE_ONLY(2, "直接存储中间件缓存中,默认发布"),
    MIDDLE_WARE_ONLY_NO_PUBLISH(3, "直接存储中间件缓存中,不发布信息"),
    ALL(4, "即存储当前缓存、又存储到中间件缓存");

    /**
     * 类型
     */
    private int type;
    /**
     * 描述
     */
    private String desc;

    CachePutPolicy(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
