package com.ustcinfo.ishare.eip.admin.cache.common.callback;

import com.ustcinfo.ishare.eip.admin.cache.common.AdminCacheable;

import java.io.Serializable;

/**
 * 缓存操作回调
 *
 * @author liuchengbiao
 * @date 2019-07-31 13:31
 */
public interface IAdminCacheCallBack<CacheClass> {
    /**
     * 返回操作缓存的class
     *
     * @return
     */
    Class getCacheClass();

    /**
     * 添加或修改的回调
     *
     * @param cacheable
     * @return 是否继续放入内置缓存中，true: 继续，false、不继续
     */
    boolean putCallBack(AdminCacheable cacheable);

    /**
     * 删除缓存回调
     *
     * @param clazz
     * @param tenantId
     * @param key
     * @return 是否继续放入内置缓存中，true: 继续，false、不继续
     */
    boolean removeCallBack(Class clazz, Serializable tenantId, Serializable key);
}
