package com.ustcinfo.ishare.eip.admin.cache.common.callback;

import com.google.common.collect.Maps;
import com.ustcinfo.ishare.eip.admin.cache.common.AdminCacheable;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author liuchengbiao
 * @date 2019-07-31 13:31
 */
public class AdminCacheCallBackContext {

    /**
     * 注入的回调
     */
    private static Map<Class, IAdminCacheCallBack> callBackMap = null;

    /**
     * 注入回调
     *
     * @param callBackList
     */
    public static void reject(List<IAdminCacheCallBack> callBackList) {
        if (callBackList == null) {
            return;
        }
        if (callBackList.size() == 0) {
            return;
        }
        callBackMap = Maps.newHashMap();
        for (IAdminCacheCallBack callBack : callBackList) {
            callBackMap.put(callBack.getCacheClass(), callBack);
        }
    }

    /**
     * 更新或修改回调
     *
     * @param cacheable
     */
    public static boolean putCallBack(AdminCacheable cacheable) {
        if (callBackMap != null) {
            IAdminCacheCallBack cacheCallBack = callBackMap.get(cacheable.getClass());
            if (cacheCallBack != null) {
                return cacheCallBack.putCallBack(cacheable);
            }
        }
        return true;
    }

    /**
     * 删除回调
     *
     * @param clazz
     * @param tenantId
     * @param key
     */
    public static void removeCallBack(Class clazz, Serializable tenantId, Serializable key) {
        if (callBackMap != null) {
            IAdminCacheCallBack cacheCallBack = callBackMap.get(clazz);
            if (cacheCallBack != null) {
                cacheCallBack.removeCallBack(clazz, tenantId, key);
            }
        }
    }
}
