package com.ustcinfo.ishare.eip.admin.cache.common;

import com.ustcinfo.ishare.eip.admin.cache.common.constant.CacheGetPolicy;
import com.ustcinfo.ishare.eip.admin.cache.common.constant.CachePutPolicy;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 缓存接口
 *
 * @author liuchengbiao
 * @date 2019/4/22 下午2:09
 */
public interface IAdminCache {

    /**
     * 加载数据
     *
     * @param tenantList 租户集合
     */
    void load(List<String> tenantList);

    /**
     * 加载给定的所有类型数据，并自动订阅租户信息
     *
     * @param classList
     */
    void loadAllByClass(List<Class> classList);

    /**
     * 订阅数据
     *
     * @param tenantList 租户集合
     */
    List<String> reSubscribe(List<String> tenantList);

    /**
     * 取消订阅
     *
     * @param tenantList
     */
    void unSubscribe(List<String> tenantList);

    /**
     * 添加到缓存
     *
     * @param entity
     */
    void put(AdminCacheable entity);

    /**
     * 添加到缓存中
     *
     * @param entity
     * @param storePolicy 存储策略
     */
    void put(AdminCacheable entity, CachePutPolicy storePolicy);

    /**
     * 添加到缓存
     *
     * @param entity
     * @param timeOut 超时时间
     * @param unit    单位
     */
    void put(AdminTimeOutCacheable entity, Integer timeOut, TimeUnit unit);

    /**
     * 从缓存中删除指定类型的指定key数据
     *
     * @param clzz
     * @param key
     */
    void remove(Class<?> clzz, Serializable key);

    /**
     * 从缓存中删除某租户中指定类型的指定key数据
     *
     * @param clzz
     * @param tenant 租户的标识
     * @param key
     */
    void remove(Class<?> clzz, Serializable tenant, Serializable key);

    /**
     * 删除某一类数据
     *
     * @param clazz
     */
    void removeAll(Class<?> clazz);

    /**
     * 删除某环境中某一类数据
     *
     * @param clazz
     * @param tenant 租户标识
     */
    void removeAll(Class<?> clazz, Serializable tenant);

    /**
     * 获取指定类型的指定key的缓存数据
     *
     * @param clazz
     * @param key
     * @param <T>
     * @return
     */
    <T> T get(Class<T> clazz, Serializable key);

    /**
     * 从某租户中获取指定类型的指定key的缓存数据
     *
     * @param clazz
     * @param tenant 租户标识
     * @param key
     * @param <T>
     * @return
     */
    <T> T get(Class<T> clazz, Serializable tenant, Serializable key);

    /**
     * 获取指定缓存类型的所有key
     *
     * @param clazz
     * @param tenant
     * @return
     */
    Set<Serializable> getKeySet(Class clazz, Serializable tenant, CacheGetPolicy getPolicy);

    /**
     * 获取指定缓存类型的所有key,该key应该是和DB主键一致的
     *
     * @param clazz
     * @param tenant
     * @param getPolicy
     * @return
     */
    Set<Serializable> getOriginalKeySet(Class clazz, Serializable tenant, CacheGetPolicy getPolicy);

    /**
     * 从某租户中获取指定类型的指定key的缓存数据
     *
     * @param clazz
     * @param tenant
     * @param key
     * @param getPolicy 获取缓存的策略
     * @param <T>
     * @return
     */
    <T> T get(Class<T> clazz, Serializable tenant, Serializable key, CacheGetPolicy getPolicy);

    /**
     * 获取指定类型的所有数据
     *
     * @param clazz
     * @param <T>
     * @return
     */
    <T> List<T> getAll(Class<T> clazz);

    /**
     * 获取指定租户下指定类型的所有数据
     *
     * @param clazz
     * @param tenant
     * @param <T>
     * @return
     */
    <T> List<T> getAll(Class<T> clazz, Serializable tenant);

    /**
     * 从某租户中获取指定类型的所有数据
     *
     * @param clazz
     * @param tenant 租户标识
     * @param <T>
     * @return
     */
    <T> List<T> getAll(Class<T> clazz, Serializable tenant, CacheGetPolicy getPolicy);
}
