package com.ustcinfo.ishare.eip.admin.cache.common;

import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

import static com.ustcinfo.ishare.eip.admin.cache.common.Cache.isExpire;

/**
 * 从json字符串中解析classname
 *
 * @author liuchengbiao
 * @date 2019-07-04 14:29
 */
@Slf4j
public class CacheUtils {
    /**
     * 解析类名
     *
     * @param data
     * @return
     */
    public static String getEntityClassName(String data) {
        if (data == null) {
            return null;
        }
        int start = data.indexOf("\"className\":\"");
        if (start < 0) {
            log.error("该数据中没有className字段,{}", data);
            return null;
        }
        start += 13;
        if (start > data.length() - 1) {
            log.error("该数据中含有className字段，但是数据不符合规范,{}", data);
            return null;
        }
        int end = data.indexOf("\"", start);
        if (end < 0 || start >= end) {
            log.error("该数据中含有className字段，但是数据不符合规范,{}", data);
            return null;
        }
        return data.substring(start, end);
    }

    /**
     * 清理无效的缓存
     */
    public static void clear() {
        long start = System.currentTimeMillis();
        log.info("开始清理过期缓存数据,版本号: {}", start);
        long count = 0;
        Map<Serializable, Map<Serializable, Map<Serializable, AdminCacheable>>> envCacheMap = Cache.getData();
        Iterator<Map.Entry<Serializable, Map<Serializable, Map<Serializable, AdminCacheable>>>> envIt = envCacheMap.entrySet().iterator();
        while (envIt.hasNext()) {
            Map.Entry<Serializable, Map<Serializable, Map<Serializable, AdminCacheable>>> next = envIt.next();
            Map<Serializable, Map<Serializable, AdminCacheable>> nextValue = next.getValue();
            if (nextValue == null) {
                envIt.remove();
                count++;
                continue;
            }
            Iterator<Map.Entry<Serializable, Map<Serializable, AdminCacheable>>> nextValueIt = nextValue.entrySet().iterator();
            while (nextValueIt.hasNext()) {
                Map.Entry<Serializable, Map<Serializable, AdminCacheable>> sonNext = nextValueIt.next();
                Map<Serializable, AdminCacheable> sonNextValue = sonNext.getValue();
                if (sonNextValue == null) {
                    nextValueIt.remove();
                    count++;
                    continue;
                }
                Iterator<Map.Entry<Serializable, AdminCacheable>> it = sonNextValue.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Serializable, AdminCacheable> next1 = it.next();
                    AdminCacheable adminCacheable = next1.getValue();
                    if (adminCacheable == null) {
                        it.remove();
                        count++;
                        continue;
                    }
                    if (isExpire(adminCacheable)) {
                        it.remove();
                        count++;
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        log.info("本次清理耗时时间: {} 毫秒，共清理 {} 个无效缓存，版本号:{}", (end - start), count, start);
    }
}
