var basegrid=$('#SysExternalAccountApply_datagrid');
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchSysExternalAccountApply();
			}
		}
	});
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		toolbar:"#SysExternalAccountApply_datagrid_tb",
	    url:ctx+'/SysExternalAccountApply/pageSysExternalAccountApply',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.externalAccountApplyId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    //{field:'externalAccountApplyId',title:'主键',width:100,align:'center',halign:'center',sortable:true},
	    {field:'applyPersonName',title:'账号申请人姓名',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'applyPersonId',title:'账号申请人编码',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'managerAccountId',title:'账号管理人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'managerAccountName',title:'账号管理人',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isUse',hidden:true},
	    //{field:'isUseText',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	    {field:'applyTime',title:'申请时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'accountType',hidden:true},
	    //{field:'accountTypeText',title:'外部账号类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'managerType',hidden:true},
	    //{field:'managerTypeText',title:'管理人类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'applyPersonPhone',title:'联系电话',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'remarks',title:'备注',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'openingInstructions',title:'开通说明(开通的原因)',width:100,align:'center',halign:'center',sortable:true},
	    {field:'accountStatus',hidden:true},
	    {field:'accountStatusText',title:'账号开通状态',width:100,align:'center',halign:'center',sortable:true},
	    {field:'accountExpiryDate',title:'账号有效期至',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'accountBelong',title:'账号归属部门',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'processinstid',title:'流程实例ID',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatus',hidden:true},
	    {field:'workflowStatusText',title:'流程状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.externalAccountApplyId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('SysExternalAccountApply_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=SysExternalAccountApply&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchSysExternalAccountApply(){
	basegrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		search:$("#searchSysExternalAccountApply").val()
	});
}

//增加记录
function addSysExternalAccountApply() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=SysExternalAccountApply",
		submiturl:"/SysExternalAccountApply/saveSysExternalAccountApply?formcode=SysExternalAccountApply",
		callback:reloadGrid
	});
	
}

//修改记录
function editSysExternalAccountApply() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.externalAccountApplyId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=SysExternalAccountApply&id=" + id,
			submiturl:"/SysExternalAccountApply/saveSysExternalAccountApply?formcode=SysExternalAccountApply",
			//onload : "/SysExternalAccountApply/findSysExternalAccountApply?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delSysExternalAccountApply() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.externalAccountApplyId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/SysExternalAccountApply/delSysExternalAccountApply",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.externalAccountApplyId,
			formCode:"SysExternalAccountApply",
			callback:reloadGrid
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}


function printSysExternalAccountApply(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		window.open(ctx+'/SysExternalAccountApply/SysExternalAccountApplyTable?id='+row.externalAccountApplyId);
	}else{
		alertInfo('请先选择要打印的数据信息');
	}
}