var basetree=$('#BasRegion_tree');
var baseform=$('#BasRegion_form');
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/BasRegion/treeBasRegionWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				/*var nodeView = $(this).tree('find',1000005);
				$(this).tree('expandTo',nodeView.target);
				$(this).tree('expand',nodeView.target);*/
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delBasRegion').linkbutton('enable'); //删除
		$('#saveBasRegion').linkbutton('enable'); //保存
	}else{
		$('#delBasRegion').linkbutton('disable');
		$('#saveBasRegion').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/BasRegion/findBasRegion?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetBasRegion(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addBasRegion() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	baseform.form('clear');
	$('#regionPid').combotree('setValue',node.id);
	$('#saveBasRegion').linkbutton('enable');
}

//删除
function delBasRegion() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/BasRegion/delBasRegionAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function saveBasRegion(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/BasRegion/saveBasRegion",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveBasRegion').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.regionId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
							target : selectnode.target,
							text : result.o.regionName

						});
					} else {
						basetree.tree('append', {
							parent : selectnode.target,
							data : [{
								id:result.o.regionId,
								text:result.o.regionName
							}]
						});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',result.o.regionId);
					basetree.tree('select', newnode.target);
					newnode.attributes=result.o;
					$('#saveBasRegion').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#saveBasRegion').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}
