var $ReportBaseColumn_datagrid=$('#ReportBaseColumn_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	$ReportBaseColumn_datagrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#ReportBaseColumn_datagrid_tb",
	    url:ctx+'/ReportBaseColumn/pageReportBaseColumn',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.ID+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'ID',title:'id',width:100,align:'center',halign:'center'},
	    {field:'REPORT_ID',title:'reportId',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_NAME',title:'名称',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_CODE',title:'编码',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_TYPE',title:'查询列类型',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_WIDTH',title:'列宽',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_COLSPAN',title:'合并行',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_ROWSPAN',title:'和并列',width:100,align:'center',halign:'center'},
	    {field:'COLUMN_ALIGN',title:'对齐',width:100,align:'center',halign:'center'},
	    {field:'STYLER_FUNCTION',title:'单元格styler(样式)函数',width:100,align:'center',halign:'center'},
	    {field:'ORDER_BY',title:'排序',width:100,align:'center',halign:'center'},
	    {field:'IS_SEARCH',hidden:true},
	    {field:'IS_SEARCH_TEXT_',title:'是否查询字段',width:100,align:'center',halign:'center'},
	    {field:'DIC_CODE',title:'字典编码',width:100,align:'center',halign:'center'},
	    {field:'DATA_URL',title:'数据源',width:100,align:'center',halign:'center'},
	    {field:'SEARCH_OPTIONS',title:'查询框配置',width:100,align:'center',halign:'center'},
	    {field:'IS_FROZEN',hidden:true},
	    {field:'IS_FROZEN_TEXT_',title:'是否冻结',width:100,align:'center',halign:'center'},
	    {field:'IS_USE',title:'是否启用',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.ID);
	    }
	});
    $ReportBaseColumn_datagrid.datagrid('doCellTip');
    var pager = $ReportBaseColumn_datagrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('ReportBaseColumn_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseColumn_Form&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	$ReportBaseColumn_datagrid.datagrid('reload');
}
//查询表格
function searchReportBaseColumn(){
	$ReportBaseColumn_datagrid.datagrid('load',{
		search:$("#searchReportBaseColumn").val()
	});
}

//增加记录
function addReportBaseColumn() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseColumn_Form",
		submiturl:"/ReportBaseColumn/saveReportBaseColumn?formcode=ReportBaseColumn_Form",
//		contenturl:"/view/report/ReportBaseColumn_Form",
//		submiturl:"/ReportBaseColumn/saveReportBaseColumn",
		callback:reloadGrid
	});
	
}

//修改记录
function editReportBaseColumn() {
	var row = $ReportBaseColumn_datagrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=ReportBaseColumn_Form&id=" + id,
			submiturl:"/ReportBaseColumn/saveReportBaseColumn?formcode=ReportBaseColumn_Form",
//			contenturl : "/view/report/ReportBaseColumn_Form",
//			submiturl : "/ReportBaseColumn/saveReportBaseColumn",
//			onload : "/ReportBaseColumn/findReportBaseColumn?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delReportBaseColumn() {
	var row = $ReportBaseColumn_datagrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/ReportBaseColumn/delReportBaseColumn",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							$ReportBaseColumn_datagrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
