var basegrid=$('#ReportBaseChart_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#ReportBaseChart_datagrid_tb",
	    url:ctx+'/ReportBaseChart/pageReportBaseChart',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.ID+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'ID',title:'id',width:100,align:'center',halign:'center'},
	    {field:'REPORT_ID',title:'reportId',width:100,align:'center',halign:'center'},
	    {field:'DS_ID',title:'名称',width:100,align:'center',halign:'center'},
	    {field:'CHART_TYPE',hidden:true},
	    {field:'CHART_TYPE_TEXT_',title:'图类型',width:100,align:'center',halign:'center'},
	    {field:'IS_STACK',hidden:true},
	    {field:'IS_STACK_TEXT_',title:'是否堆叠',width:100,align:'center',halign:'center'},
	    {field:'IS_3D',hidden:true},
	    {field:'IS_3D_TEXT_',title:'是否3D',width:100,align:'center',halign:'center'},
	    {field:'CLASS_FIELD',title:'分类',width:100,align:'center',halign:'center'},
	    {field:'NAME_FIELD',title:'系列名',width:100,align:'center',halign:'center'},
	    {field:'VALUE_FIELD',title:'值',width:100,align:'center',halign:'center'},
	    {field:'CHART_TILE',title:'图标标题',width:100,align:'center',halign:'center'},
	    {field:'SHOW_LEGEND',title:'显示图例',width:100,align:'center',halign:'center'},
	    {field:'LEGEND_ALIGN',hidden:true},
	    {field:'LEGEND_ALIGN_TEXT_',title:'图例显示位置',width:100,align:'center',halign:'center'},
	    {field:'SHOW_LABEL',title:'显示标签',width:100,align:'center',halign:'center'},
	    {field:'LABEL_FORMATTER',title:'标签格式',width:100,align:'center',halign:'center'},
	    {field:'LABEL_ALIGN',hidden:true},
	    {field:'LABEL_ALIGN_TEXT_',title:'标签显示位置',width:100,align:'center',halign:'center'},
	    {field:'CHART_OPTIONS',title:'自定义配置',width:100,align:'center',halign:'center'},
	    {field:'IS_USE',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'CREATE_BY',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'CREATE_TIME',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_ACCOUNT',title:'修改人',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_TIME',title:'修改时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.ID);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('ReportBaseChart_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseChart_Form&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchReportBaseChart(){
	basegrid.datagrid('load',{
		search:$("#searchReportBaseChart").val()
	});
}

//增加记录
function addReportBaseChart() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseChart_Form",
		submiturl:"/ReportBaseChart/saveReportBaseChart?formcode=ReportBaseChart_Form",
//		contenturl:"/view/report/ReportBaseChart_Form",
//		submiturl:"/ReportBaseChart/saveReportBaseChart",
		callback:reloadGrid
	});
	
}

//修改记录
function editReportBaseChart() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=ReportBaseChart_Form&id=" + id,
			submiturl:"/ReportBaseChart/saveReportBaseChart?formcode=ReportBaseChart_Form",
//			contenturl : "/view/report/ReportBaseChart_Form",
//			submiturl : "/ReportBaseChart/saveReportBaseChart",
//			onload : "/ReportBaseChart/findReportBaseChart?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delReportBaseChart() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/ReportBaseChart/delReportBaseChart",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
