var PubContactOrgScoreDataGrid=$('#PubContactOrgScore_datagrid');
var fcode="PubContactOrgScore";
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubContactOrgScore();
			}
		}
	});
	getFcode();
	initPubContactOrgScoreGrid();
});

function initPubContactOrgScoreGrid(){
	PubContactOrgScoreDataGrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		height:$("body").height()-200,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
			type : type
		},
		toolbar:"#PubContactOrgScore_datagrid_tb",
	    url:ctx+'/PubContactOrgScore/pagePubContactOrgScore',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="PubContactOrgScoreFormDetail('+row.contactOrgScoreId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'contactOrgScoreNo',title:'单据编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contactOrgIdText',title:'客商名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'finalScore',title:'最终评分',width:100,align:'center',halign:'center',sortable:true},
	    {field:'sroreDate',title:'评价年度',width:100,align:'center',halign:'center',sortable:true},
	    {field:'orgIdText',title:'申请单位',width:100,align:'center',halign:'center',sortable:true},
	    {field:'deptIdText',title:'申请部门',width:100,align:'center',halign:'center',sortable:true},
	    {field:'empIdText',title:'申请人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			PubContactOrgScoreFormDetail(row.contactOrgScoreId);
	    }
	});
    PubContactOrgScoreDataGrid.datagrid('doCellTip');
    var pager = PubContactOrgScoreDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubContactOrgScore_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function PubContactOrgScoreFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode="+fcode+"&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadPubContactOrgScore(){
	PubContactOrgScoreDataGrid.datagrid('reload');
}
//查询表格
function searchPubContactOrgScore(){
	PubContactOrgScoreDataGrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		search:$("#searchPubContactOrgScore").val(),
		type : type
	});
}

//增加记录
function addPubContactOrgScore() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		submitType : 'single',
		contenturl:"/GenForm/form?formcode="+fcode,
		submiturl:"/PubContactOrgScore/savePubContactOrgScore?formcode="+fcode,
		callback:reloadPubContactOrgScore
	});
	
}

//修改记录
function editPubContactOrgScore() {
	var row = PubContactOrgScoreDataGrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.contactOrgScoreId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode="+fcode+"&id=" + id,
			submiturl:"/PubContactOrgScore/savePubContactOrgScore?formcode="+fcode,
			//onload : "/PubContactOrgScore/findPubContactOrgScore?id=" + id,
			callback : reloadPubContactOrgScore
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delPubContactOrgScore() {
	var row = PubContactOrgScoreDataGrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.contactOrgScoreId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubContactOrgScore/delPubContactOrgScore",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							PubContactOrgScoreDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = PubContactOrgScoreDataGrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.contactOrgScoreId,
			formCode:fcode,
			callback:reloadPubContactOrgScore
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = PubContactOrgScoreDataGrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function getFcode(){
	if("2"==type){
		fcode = "PubContactOrgScoreKH";
	}
}