var PubContactOrgBlockDataGrid=$('#PubContactOrgBlock_datagrid');
var fcode='PubContactOrgBlock';
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubContactOrgBlock();
			}
		}
	});
	if('3'==type||'4'==type){
		fcode='PubContactOrgBlock_remove';
	}
	initPubContactOrgBlockGrid();
});

function initPubContactOrgBlockGrid(){
	PubContactOrgBlockDataGrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		height:$("body").height()-200,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
			type:type
		},
		toolbar:"#PubContactOrgBlock_datagrid_tb",
	    url:ctx+'/PubContactOrgBlock/pagePubContactOrgBlock',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="PubContactOrgBlockFormDetail('+row.contactOrgBlockId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'contactOrgBlockNo',title:'单据编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contactOrgName',title:'客商名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateTypeText',title:'调整方式',width:100,align:'center',halign:'center',sortable:true},
	    {field:'reason',title:'申请原因',width:100,align:'center',halign:'center',sortable:true},
	    {field:'empIdText',title:'申请人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			PubContactOrgBlockFormDetail(row.contactOrgBlockId);
	    }
	});
    PubContactOrgBlockDataGrid.datagrid('doCellTip');
    var pager = PubContactOrgBlockDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubContactOrgBlock_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function PubContactOrgBlockFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode="+fcode+"&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadPubContactOrgBlock(){
	PubContactOrgBlockDataGrid.datagrid('reload');
}
//查询表格
function searchPubContactOrgBlock(){
	PubContactOrgBlockDataGrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
	    type:type,
		search:$("#searchPubContactOrgBlock").val()
	});
}

//增加记录
function addPubContactOrgBlock() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		submitType : 'single',
		contenturl:"/GenForm/form?formcode="+fcode,
		submiturl:"/PubContactOrgBlock/savePubContactOrgBlock?formcode="+fcode,
		onload:function(){
			if('1'==type){
				$('#operateType').combobox('setValue','1');
				$('#orgType').val('1');
			}else if('2'==type){
				$('#operateType').combobox('setValue','1');
				$('#orgType').val('2');
			}else if('3'==type){
				$('#operateType').combobox('setValue','2');
				$('#orgType').val('1');
			}else if('4'==type){
				$('#operateType').combobox('setValue','2');
				$('#orgType').val('2');
			}
		},
		callback:reloadPubContactOrgBlock
	});
	
}

//修改记录
function editPubContactOrgBlock() {
	var row = PubContactOrgBlockDataGrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.contactOrgBlockId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode="+fcode+"&id=" + id,
			submiturl:"/PubContactOrgBlock/savePubContactOrgBlock?formcode="+fcode,
			//onload : "/PubContactOrgBlock/findPubContactOrgBlock?id=" + id,
			callback : reloadPubContactOrgBlock
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delPubContactOrgBlock() {
	var row = PubContactOrgBlockDataGrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.contactOrgBlockId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubContactOrgBlock/delPubContactOrgBlock",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							PubContactOrgBlockDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = PubContactOrgBlockDataGrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.contactOrgBlockId,
			formCode:fcode,
			callback:reloadPubContactOrgBlock
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = PubContactOrgBlockDataGrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}