var COMTree = $("#COMTree");
var panelDialog=$('#panel-dialog');
var comid=0;
function newComId(){
	comid++;
	return 'com_'+comid;
	
}

function alertCOMData(){
var data=COMTree.tree('getRoots');
	alert(JSON.stringify(data));
	console.log(data)
}
$(function() {
			initCOMTree();
		});

function initCOMTree() {
	COMTree.tree({
				lines : true,
				url : ctx + '/genpage/COMTree',
				queryParams : {
					id : getUrlParam("id")
				},
				onContextMenu : function(e, node) {
					e.preventDefault();
					$(this).tree('select', node.target);
					var comtreemenu = creatCOMMenu(node);
					comtreemenu.menu('show', {
								left : e.pageX,
								top : e.pageY
							});
				}
			});
}

function creatCOMMenu(node) {
	var comtreemenu = $('#COMTree-menu').empty();// 清除所有菜单
	if (node.attributes.com.cls == "easyui-layout") {
		comtreemenu.menu('appendItem', {
				text : '添加-主面板',
					onclick : function() {
						createPanel(node,'center');
					}
				});
		comtreemenu.menu('appendItem', {
					text : '添加-上面板',
					onclick : function() {
						createPanel(node,'north');
					}
				});
		comtreemenu.menu('appendItem', {
					text : '添加-下面板',
					onclick : function() {
						createPanel(node,'south');
					}
				});
		comtreemenu.menu('appendItem', {
					text : '添加-左面板',
					onclick : function() {
						createPanel(node,'west');
					}
				});
		comtreemenu.menu('appendItem', {
					text : '添加-右面板',
					onclick : function() {
						createPanel(node,'east');
					}
				});

	}
	
	if (node.attributes.com.cls == "easyui-layout-panel") {
		comtreemenu.menu('appendItem', {
					text : '删除',
					onclick : function() {
						var parentnode=COMTree.tree('getParent',node.target);
						$('#'+parentnode.id).layout('remove',node.attributes.com.options.region);
						COMTree.tree('remove',node.target);
					}
				});
		comtreemenu.menu('appendItem', {
					text : '添加工具条',
					onclick : function() {
						var parentnode=COMTree.tree('getParent',node.target);
						var panel=$('#'+parentnode.id).layout('panel',node.attributes.com.options.region);
						var paneloptions=panel.panel('options');
						var comid=newComId();
						var panel_toolbar=$('<div id='+comid+' class="app-toolbar"></div>')
						
						if(paneloptions.title){//如果有标题
							panel.panel('header').remove();
							paneloptions.header=panel_toolbar;
							panel.panel(paneloptions);
//							panel.panel('header').append(panel_toolbar);
						}else{
							panel.panel({
								header:panel_toolbar
							});
						}
						
						COMTree.tree('append', {
								parent: node.target,
						 		data:[{
						 			id:comid,
						 			text: '工具栏',
						 			attributes:{
						 				com:{
						 					cls:"app-toolbar",
						 					options:{
						 					}
						 				}
						 			}
						 		}]
						 });
						
					}
				});
				
		comtreemenu.menu('appendItem', {
					text : '添加表格',
					onclick : function() {
						var comid=newComId();
						var parentnode=COMTree.tree('getParent',node.target);
						var panel=$('#'+parentnode.id).layout('panel',node.attributes.com.options.region);
						var panelbody=panel.panel('body');
						panelbody.append("<div id="+comid+"></div>");
						$('#'+comid).datagrid({
							fit:true,
							border:false,
							singleSelect:true,
							rownumbers:true,
							fitColumns:true,
							pagination:true,
							toolbar:"#dic_datagrid_tb",
						    url:ctx+'/dic/getalltype',
						    columns:[[
						        {field:'DIC_ID',title:'id',checkbox:true},
						        {field:'DIC_NAME',title:'字典名称',width:80},
						        {field:'DIC_CODE',title:'字典编码',width:80},
						        {field:'DIC_TEXT',title:'文字',width:80},
						        {field:'DIC_VALUE',title:'值',width:80},
						        {field:'IS_DEFAULT',title:'是否默认值',width:80,formatter:function(value,row,index){
						        	return value==1?"<span class='blue icon-default'/>":"";
						        }},
						        {field:'DISPLAY_NO',title:'显示顺序',width:80},
						        {field:'MEMO',title:'备注',width:100}
						    ]]
						});
						COMTree.tree('append', {
								parent: node.target,
						 		data:[{
						 			id:comid,
						 			text: '表格',
						 			attributes:{
						 				com:{
						 					cls:"easyui-datagrid",
						 					options:{
						 					}
						 				}
						 			}
						 		}]
						 });
						
					}
				});			
	}
	// 工具条右键菜单
	if (node.attributes.com.cls == "app-toolbar") {
		comtreemenu.menu('appendItem', {
					text : '添加按钮',
					onclick : function() {
						$('#'+node.id).append('<a id="btn" href="#" class="easyui-linkbutton easyui-draggable" data-options="">easyui</a>');
						$.parser.parse('#'+node.id);
						var comid=newComId();
						COMTree.tree('append', {
								parent: node.target,
						 		data:[{
						 			id:comid,
						 			text: '按钮'+comid,
						 			attributes:{
						 				com:{
						 					cls:"easyui-linkbutton",
						 					options:{
						 					}
						 				}
						 			}
						 		}]
						 });
						
					}
				});
	}
	
	return comtreemenu;
}

function createPanel(node, region) {
	var options = {
		region : region
	};
	panelDialog.dialog({
		closed : false,
		cache : false,
		modal : true,
		buttons : [{
					text : '确定',
					iconCls : 'icon-add',
					handler : function() {
						options.id = newComId();
						options.title = $("#panel_title").textbox('getValue');
						options.split = true;
						if (region == 'north' || region == 'south') {
							options.height = $("#panel_height").numberbox('getValue');
						} else {
							options.width = $("#panel_width").numberbox('getValue');
						}
						 $('#'+node.id).layout('add', options);
						 COMTree.tree('append', {
								parent: node.target,
						 		data:[{
						 			id:newComId(),
						 			text: options.title==''?'新建面板':options.title,
						 			attributes:{
						 				com:{
						 					cls:"easyui-layout-panel",
						 					options:{
						 						region:region
						 					}
						 				}
						 			}
						 		}]
						 });
						 panelDialog.dialog('close');
					}
				}, {
					text : '取消',
					iconCls : 'icon-save',
					handler : function() {
						panelDialog.dialog('close');
					}
				}]
	});

}
