var basegrid=$('#DocFileVersion_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#DocFileVersion_datagrid_tb",
	    url:ctx+'/DocFileVersion/pageDocFileVersion',
	    columns:[[
	    {field:'VERSION_ID',title:'版本ID'},
	    {field:'VERSION_NO',title:'版本号'},
	    {field:'FILE_ID',title:'文件ID'},
	    {field:'ORIGINAL_NAME',title:'原始文件名称'},
	    {field:'FILE_SUFFIX',title:'后缀'},
	    {field:'CREATE_ACCOUNT',title:'创建人'},
	    {field:'CREATE_TIME',title:'创建时间'},
	    {field:'IS_USE',title:'是否启用'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchDocFileVersion(){
	basegrid.datagrid('load',{
		search:$("#searchDocFileVersion").val()
	});
}

//增加数据字典
function addDocFileVersion() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/doc/DocFileVersionform",
		submiturl:"/DocFileVersion/saveDocFileVersion",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editDocFileVersion() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.FILE_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/doc/DocFileVersionform",
			submiturl : "/DocFileVersion/saveDocFileVersion",
			onload : "/DocFileVersion/findDocFileVersion?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delDocFileVersion() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.FILE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/DocFileVersion/delDocFileVersion",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
