var basegrid=$('#DocFile_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#DocFile_datagrid_tb",
	    url:ctx+'/DocFile/pageDocFile',
	    columns:[[
	    {field:'FILE_ID',title:'id'},
	    {field:'FILE_CODE',title:'文件编码'},
	    {field:'FILE_NAME',title:'文件名称'},
	    {field:'CATALOG_ID',title:'目录ID'},
	    {field:'STANDARD_FILE_ID',title:'标准文件ID'},
	    {field:'PROJECT_ID',title:'项目ID'},
	    {field:'FILE_TYPE',hidden:true},
	    {field:'FILE_TYPE_TEXT_',title:'文件类型'},
	    {field:'CREATE_ACCOUNT',title:'创建人'},
	    {field:'CREATE_TIME',title:'创建时间'},
	    {field:'BASE_VERSION_ID',title:'基础版本'},
	    {field:'IS_USE',title:'是否删除'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchDocFile(){
	basegrid.datagrid('load',{
		search:$("#searchDocFile").val()
	});
}

//增加数据字典
function addDocFile() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/doc/DocFileform",
		submiturl:"/DocFile/saveDocFile",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editDocFile() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.FILE_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/doc/DocFileform",
			submiturl : "/DocFile/saveDocFile",
			onload : "/DocFile/findDocFile?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delDocFile() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.FILE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/DocFile/delDocFile",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
