var basegrid=$('#WfAgent_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		cls:'md',
		pagination:true,
		height:$("body").height()-135,
		toolbar:"#WfAgent_datagrid_tb",
	    url:ctx+'/WfAgent/pageWfAgent',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.agentId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
//	    {field:'agentId',title:'代理主键',width:100,align:'center',halign:'center'},
	    {field:'agentToAccountName',title:'被代理人',width:80,align:'center',halign:'center'},
	    {field:'agentAccountName',title:'代理人',width:80,align:'center',halign:'center'},
	    {field:'startDate',title:'代理开始时间',width:100,align:'center',halign:'center'},
	    {field:'endDate',title:'代理结束时间',width:100,align:'center',halign:'center'},
	    {field:'cancelDate',title:'代理取消时间',width:100,align:'center',halign:'center'},
	    {field:'agentType',hidden:true},
	    {field:'agentTypeText',title:'代理类型',width:80,align:'center',halign:'center'},
	    {field:'agentRemin',hidden:true},
	    {field:'agentReminText',title:'代理办理是否提醒',width:80,align:'center',halign:'center'}/*,
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center'},
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center'},
	    {field:'agentContent',title:'代理内容',width:100,align:'center',halign:'center'}*/
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.agentId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('WfAgent_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfAgent&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchWfAgent(){
	basegrid.datagrid('load',{
		search:$("#searchWfAgent").val(),
		agentAccountName:$('#agentAccountName').textbox('getValue')
	});
}

//增加记录
function addWfAgent() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=WfAgent",
		submiturl:"/WfAgent/saveWfAgent?formcode=WfAgent",
//		contenturl:"/view/business/workflow/WfAgent",
//		submiturl:"/WfAgent/saveWfAgent",
		callback:reloadGrid
	});
	
}

//修改记录
function editWfAgent() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.cancelDate){
			alertInfo('已经取消不能修改');
			return;
		}
		var id = row.agentId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=WfAgent&id=" + id,
			submiturl:"/WfAgent/saveWfAgent?formcode=WfAgent",
//			contenturl : "/view/business/workflow/WfAgent",
//			submiturl : "/WfAgent/saveWfAgent",
//			onload : "/WfAgent/findWfAgent?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//取消委派
function delWfAgent() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.agentId;
		alertConfirmYes('您是否要取消当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/WfAgent/cancelWfAgent",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要取消的数据信息');
	}
}
