// 新增修改标记,0意味着新增,1意味着修改
var saveFlag = 1;

$(function() {
	//查询所属单位
	// 加载组织机构下拉框,作为检索条件
	$('#orgselect_tree').combotree({
		url : ctx + '/basorg/queryOrgmenu.action',
		editable : true,
		limitToList : true,
		onLoadSuccess : function() {
			var node = $('#orgselect_tree').combotree("tree").tree('getRoot');
			// 设置选中值
			$('#orgselect_tree').combotree("setValue", node.id);
		},
		onChange : function(newvalue,oldvalue) {
			queryByOrg(newvalue);
		}
	});
});

// 根据选中的组织机构,对该组织机构下的部门信息进行检索
function queryByOrg(orgid) {
	$('#deptManage_form').form('clear');
	var pid = 0;
	var orgId = orgid;
	$('#deptManage_tree').tree({
		url : ctx + "/basdept/queryDeptmenu?pid=" + pid
				+ "&orgId=" + orgId+"&isTree=true",
		onSelect : function(node) {
			openDept(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
function controlBtn(isable){
	if(isable){
		$('#removeBtn').linkbutton('enable'); //删除
		$('#saveBtn').linkbutton('enable'); //保存
		$('#cancelBtn').linkbutton('enable'); //重置
	}else{
		$('#removeBtn').linkbutton('disable');
		$('#saveBtn').linkbutton('disable');
		$('#cancelBtn').linkbutton('disable');
	}
}
// 单击打开节点
function openDept(node) {
	if(node.id=="0"){
		controlBtn(false);
	}else{
		controlBtn(true);
	}
	$('#deptManage_form').form('clear');
	$.ajax({
		type : 'post',
		url : ctx + '/basdept/queryDeptInfo?deptId=' + node.id,
		dataType : 'json',
		success : function(data) {
			$('#deptManage_form').form('load',data);
		}
	});
}

// 新增部门信息
function newDept() {
	saveFlag = 0;
	var orgId=$('#orgselect_tree').combotree('getValue');
	if(orgId){
		$('#saveBtn').linkbutton('enable');
		// 获取选中的节点
		var node = $('#deptManage_tree').tree('getSelected');
		// 清除当前界面信息
		$('#deptManage_form').form('clear');
		// 构建树结构
		if(node){
			$('#pdept_id').val(node.id);
		}else{
			$('#pdept_id').val(0);
		}
		var orgId=$('#orgselect_tree').combotree('getValue');
		$('#orgId').combotree('setValue',orgId);
		$('#is_use').val('Y');
	}else{
		alertInfo("请先选择一条组织机构");
	}
}

// 删除部门信息
function removeDept() {
	// 获取选中的节点
	var node = $('#deptManage_tree').tree('getSelected');
	if(node){
		var child = $('#deptManage_tree').tree('isLeaf', node.target);
		if (child) {
			// 不存在子节点
			alertConfirm('确定删除该部门结构?', function(r) {
				if (r) {
					$.ajax({
						type : 'post',
						dataType : 'json',
						url : ctx + "/basdept/deleDept?deptId=" + node.id,
						success : function(result) {
							if (result.success) {
								var pnode = $('#deptManage_tree').tree('getParent',node.target);
								$('#deptManage_tree').tree('select', pnode.target);
								// 移除节点
								$('#deptManage_tree').tree('remove', node.target);
								alertInfo(result.msg);
							}else {
								alertError(result.msg);
							}
						},
						error : function() {
							alertError(result.msg);
						}
					});
				}
			});
		} else {
			// 存在子节点
			alertConfirm('将删除该部门机构及其子机构,确定进行本次操作?', function(r) {
				if (r) {
					$.ajax({
						type : 'post',
						dataType : 'json',
						url : ctx + "/basdept/deleDepts?deptId=" + node.id,
						success : function(result) {
							if (result.success) {
								var pnode = $('#deptManage_tree').tree('getParent',node.target);
								$('#deptManage_tree').tree('select', pnode.target);
								// 移除节点
								$('#deptManage_tree').tree('remove', node.target);
								alertInfo(result.msg);
							}else {
								alertError(result.msg);
							}
						},
						error : function() {
							alertError(result.msg);
						}
					});
				}
			});
		}
	}else{
		alertInfo("请先选择一个部门再进行删除操作");
	}
}

// 保存部门信息
function saveDept() {
	if($('#pdept_id').val()==""){
		alertInfo("根节点无需保存");
	}else{
		$('#deptManage_form').form('enableValidation');
		$('#deptManage_form').form('submit', {
			url : ctx + "/basdept/saveDept",
			dataType : 'json',
			onSubmit : function() {
				if($(this).form('validate')){
	        		// 防止重复发送
	        		$('#saveBtn').linkbutton('disable');
	             	return true;
	        	 }else{
	        		 return false;
	        	 }
			},
			success : function(result) {
				result=jQuery.parseJSON(result);
				var resultnode = $('#deptManage_tree').tree('find',result.o.deptId);
				if (result.success) {
					// 获取选中的节点
					var node = $('#deptManage_tree').tree('getSelected');
					if (resultnode) {
						// 修改
						$('#deptManage_tree').tree('update',{
							 target: node.target,
							 text : result.o.abbr,
							 attributes:{
								 deptcode:result.o.deptCode
							}
						 });
						alertInfo(result.msg);
						// 启用按钮
						$('#saveBtn').linkbutton('enable');
					} else {
						// 增加
						$('#deptManage_tree').tree('append', {
							parent : node.target,
							data:[{
								id:result.o.deptId,
								text: result.o.abbr,
								attributes:{
									deptcode:result.o.deptCode
								}
							}]
						});
						var newnode = $('#deptManage_tree').tree('find',result.o.deptId);
						$('#deptManage_tree').tree('select', newnode.target);
						alertInfo(result.msg);
					}
				} else {
					alertError(result.msg);
				}
			}
		});
	}
}

//取消按钮,取消当前编辑
function cancelDept() {
	if(saveFlag == 1){
		var node = $('#deptManage_tree').tree('getSelected');
		if(node){
			openDept(node);
		}
	}else{
		newDept();
	}
}
function pushBasDept(){
	var node = $('#deptManage_tree').tree('getSelected');
	if (node) {
		alertConfirmYes('您是否要推送当前部门到财务系统？', function(r) {
			if (r) {
				var loadIndex = layer.msg('数据同步中...', {
					icon: 16,
					shade: 0.3, time: 0
				});
				$.ajax({
					type : 'post',
					url : ctx+"/basdept/genDeptXml",
					data:{
						deptId : node.id
					},
					dataType : 'json',
					success : function(result) {
						layer.close(loadIndex);
						if (result.success) {
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					},
					error: function () {
						layer.close(loadIndex);
						alertError("数据同步出错");
					}
				});
			
			} 
		});
	}else {
		alertInfo('请先选择要推送的数据信息');
	}
}


