// 提醒消息列表
var messageGrid = $('#accountMessage_datagrid');

$(function() {
	initGrid();
});

// 初始化grid
function initGrid() {
	messageGrid.datagrid({
		//fit : true,
		border : false,
		cls:'md',
		height:$("body").height()-155,
		singleSelect : false,
		queryParams:{
			msgType:msgType,
			isRead:$("#isRead").combobox("getValue")
		},
		rownumbers : true,
		fitColumns : true,
		pagination : true,
		toolbar : "#accountMessage_datagrid_tb",
		url : ctx + '/BasMessage/pageAccountMessageList',
		columns : [ [
				{field:'opt',checkbox:true},
				{
					field : 'det',
					title : '明细',
					width : 13,
					formatter : function(value, row, index) {
						var url ;
						if(row.FORM_CODE=='EdocApply'){
							url = "/EdocApply/openPrintPage?id="+row.BUSI_MAIN_ID+"&msgId="+row.MSG_ID;
						} else if(row.MSG_URL){
							url = row.MSG_URL;
						}else{
							url = '/GenForm/form?newpage=true&isdetail=true&id='+row.BUSI_MAIN_ID+'&formcode='+row.FORM_CODE;	
						}
						return '<div onclick="openMessageDetail(\''
								+ row.MSG_TITLE + '\',\'' + row.MSG_ID
								+ '\',\'' + url
								+ '\')" class="icon-detail iconfont blue">&nbsp;</div>';
					}
				}, {
					field : 'MSG_ID',
					title : 'msgId',
					hidden : true
				}, {
					field : 'MSG_URL',
					title : 'msgUrl',
					hidden : true
				}, {
					field : 'MSG_TITLE',
					title : '标题',
					width : 200
				}, {
					field : 'IS_READ',
					title : '是否阅读',
					width : 100,
					formatter : function(value, row, index) {
						if (value == "Y") {
							return "已读";
						} else if (value == "N") {
							return '<font color="red">未读</font>';
						}
					}
				}, {
					field : 'SEND_TIME',
					title : '发送时间',
					width : 100
				}, {
					field : 'ACCOUNT_NAME',
					title : '发送人员',
					width : 100
				}  ] ],
		onDblClickRow : function(index, row) {
			openMessageDetail(row.MSG_TITLE, row.MSG_ID, row.MSG_URL);
		}
	});
}

// 查询提醒信息列表
function searchMessageList() {
	messageGrid.datagrid('load', {
		msgType:msgType,
		isRead:$("#isRead").combobox("getValue"),
		search : $("#searchMessageList").val()
	});
}

// 打开提醒消息详细页面
function openMessageDetail(title, id, msgUrl) {
	parent.openInMainTab(title, msgUrl);
	var ids = [];
	ids.push(id);
	setMsgIsRead(ids);
}

function setMsgIsRead(ids){
	if(!ids){
		ids = [];
		var rows = messageGrid.datagrid("getSelections");
		if(rows.length==0){
			alertInfo("请先选择消息");
			return ;
		}
		for(i=0;i<rows.length;i++){
			ids.push(rows[i].MSG_ID);
		}
	}
	$.ajax({
		type : "POST",
		url : ctx + "/BasMessage/setMsgIsRead",
		data : "msgIds=" + ids.join(','),
		dataType : "json",
		success : function(result) {
			searchMessageList();
			getMessageList();
		}
	});
}

function setMsgAllRead(){
	$.ajax({
		type : "POST",
		url : ctx + "/BasMessage/setMsgIsRead",
		dataType : "json",
		success : function(result) {
			searchMessageList();
			getMessageList();
		}
	});
}

// 获取提醒消息列表
function getMessageList() {
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BasMessage/getAccountMessageList.action",
		data : {},
		success : function(result) {
			var resultObj =result;
			var htmlArray = "";
			var count = 0;
			if (resultObj.length <= 5) {
				count = resultObj.length;
			} else {
				count = 5;
			}
			if (count == 0) {
				htmlArray+="<tr><td>";
				htmlArray+="当前没有消息！"
				htmlArray+="</td></tr>"
				$("#messageList").html(htmlArray);
				$("#messageNum").css("display", "none");
			} else {
				for ( var i = 0; i < count; i++) {
					var msg = resultObj[i];
					htmlArray += "<tr>";
					htmlArray += "<td class=\"am-text-primary\"><a href=\"javascript:openMessageDetail('"
							+ msg.msgTitle
							+ "','"
							+ msg.msgId
							+ "','"
							+ msg.msgUrl
							+ "');\" >"
							+ msg.msgTitle
							+ "</a></td>";
					htmlArray += "</tr>";
				}
				$("#messageList").html(htmlArray);
				$("#messageNum").css("display", "block");
				$("#messageNum").html(resultObj.length);
			}
		}
	});
}