var basetree=$('#BaseOrg_tree');
var commongrid=$('#CommonRoles_datagrid');
var basegrid=$('#BasRoles_datagrid');
var basemenutree=$('#BasMenu_tree');
var roleId;//角色ID
var roleType;//角色类型
var orgId;//角色下组织机构
var deptId;//角色下部门
$(function(){
	initTree();
	initGrid();
});

function initTree(){
	basetree.combotree({
		editable:false,
		width:280,
		panelHeight:'auto',
		url : ctx + '/basorg/queryOrgAndDeptTree',
		onSelect : function(node) {
			//区分所选是组织机构还是部门
			var rt = 'org';
			if(node.id.substring(0,4)=='dept'){
				rt = 'dept'
			}
            //赋值
            orgId = node.attributes.org_id;
            if(node.attributes.dept_id){
            	deptId = node.attributes.dept_id;
            }else{
            	deptId = '';
            }
            //刷新组织角色表、已选人员、未选人员
            reloadCommonGrid();
			reloadGrid(rt);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
			basetree.combotree('setValue',root.id);
		}
	});
	
	basemenutree.tree({
		checkbox:true,
		url : ctx + '/ContractRightsDistribution/findRoleMenutree'
	});
}
function initGrid(){
	commongrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
	    url:ctx+'/BasRoles/pageBasRoles?roleType=sys,common',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',hidden:true},
	    {field:'ROLE_NAME',title:'角色名称',width:100},
	    {field:'ROLE_TYPE',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',width:100}
	    ]],
	    onSelect:function(index,row){
	    	//赋值
	    	roleType = 'sys,common';
	    	roleId = row.ROLE_ID;
	    	orgId = '';
	    	deptId = '';
	    	loadEmpAndMenu();
	    }
	});
	
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		toolbar:"#BasRoles_datagrid_tb",
		pagination:true,
	    url:ctx+'/BasRoles/pageBasRoles',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',hidden:true},
	    {field:'ROLE_NAME',title:'角色名称',width:100},
	    {field:'ROLE_TYPE',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',width:100}
	    ]],
	    onSelect:function(index,row){
	    	//赋值
	    	roleType = 'org,dept';
	    	roleId = row.ROLE_ID;
	    	loadEmpAndMenu();
	    }
	});
}
//角色根据类别过滤
function reloadCommonGrid(){
	commongrid.datagrid('reload',{
//		roleType:roleType
	});
}

function reloadGrid(rt){
	if(!rt){
		rt = roleType;
	}
	basegrid.datagrid('reload',{
		roleType:rt
	});
}

function loadEmpAndMenu(){
	
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	
	//角色对应菜单
	basemenutree.tree({
		checkbox : true,
		url : ctx + "/ContractRightsDistribution/findRoleMenutree?roleid=" + roleId+"&roleType="+roleType+"&orgid="+orgId+"&deptid="+deptId ,
		onBeforeLoad:function(){
			$(this).tree('options').cascadeCheck=false;
		},
		onLoadSuccess:function(){
			$(this).tree('options').cascadeCheck=true;
			$(this).tree('expandAll');
		}
	});
}

function saveMenu(){
	if(!roleId){
		alertInfo('请先选择一条角色信息,再进行模块的关联操作');
		return;
	}
	var nodes = basemenutree.tree('getChecked',['checked','indeterminate']);
	var pmcontypeids = [];
	for ( var i = 0; i < nodes.length; i++) {
		if(nodes[i].attributes.nodetype==0){
			pmcontypeids.push(nodes[i].attributes.keyid);
		}
	}
	$('#saveBtn').linkbutton('disable');
	var loadIndex = layer.msg('保存中', {icon: 16,
		  shade :0.3,time:0});
	$.ajax({
		dataType : 'json',
		type : "POST",
		data : {
			roleid : roleId,
			orgid : orgId,
			deptid : deptId,
			pmcontypeids : pmcontypeids.join(',')
		},
		url : ctx + "/ContractRightsDistribution/saveBasRolesMenu",
		success : function(result) {
			layer.close(loadIndex);
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertInfo("操作失败,请重试");
			}
			// 启用按钮
			$('#saveBtn').linkbutton('enable');
		},error:function(){
			layer.close(loadIndex);
			$('#saveBtn').linkbutton('enable');
		}
	});
}
