var BasTimedTaskLogDataGrid=$('#BasTimedTaskLog_datagrid');
$(function(){
	initBasTimedTaskLogGrid();
});

function initBasTimedTaskLogGrid(){
	BasTimedTaskLogDataGrid.datagrid({
		height:$("body").height()-172,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			startDate:$('#sDate').datebox('getValue'),
			endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#BasTimedTaskLog_datagrid_tb",
	    url:ctx+'/BasTimedTaskLog/pageBasTimedTaskLog',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasTimedTaskLogFormDetail('+row.taskLogId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
			{field:'taskName',title:'任务名称',width:90,align:'center',halign:'center',sortable:true},
			{field:'taskCode',title:'任务编码',width:80,align:'center',halign:'center',sortable:true},
			{field:'createTime',title:'运行时间',width:80,align:'center',halign:'center',sortable:true},
	    // {field:'taskLogId',title:'任务日志id',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'taskId',title:'任务id',width:100,align:'center',halign:'center',sortable:true},
	    //{field:'createAccount',title:'创建人',width:80,align:'center',halign:'center',sortable:true},
	    // {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'operateResult',hidden:true},
	    {field:'operateResultText',title:'执行状态',width:90,align:'center',halign:'center',sortable:true,

			// 改变执行状态显示效果
			formatter: function(value,row,index){
				if (value =='失败'){
					return  '<font color="red">' + value + '</font>';
				}else if (value=='成功'){
					return '成功';
				}
			}},
	    {field:'operateDetail',title:'明细',width:150,align:'center',halign:'center',sortable:true},
	    {field:'operateIp',title:'操作ip',width:120,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'是否删除',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasTimedTaskLogFormDetail(row.taskLogId);
	    }
	});
    BasTimedTaskLogDataGrid.datagrid('doCellTip');
    var pager = BasTimedTaskLogDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasTimedTaskLog_datagrid',"title");   
	        }    
	    }]   
	});
}

//查看表单明细
function BasTimedTaskLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasTimedTaskLog&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasTimedTaskLog(){
	BasTimedTaskLogDataGrid.datagrid('reload');
}
//查询表格
function searchBasTimedTaskLog(){
	BasTimedTaskLogDataGrid.datagrid('load',{
		search:$("#searchBasTimedTaskLog").val(),
		startDate:$('#sDate').datebox('getValue'),
		endDate:$('#eDate').datebox('getValue')
	});
}

//增加记录
function addBasTimedTaskLog() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasTimedTaskLog",
		submiturl:"/BasTimedTaskLog/saveBasTimedTaskLog?formcode=BasTimedTaskLog",
//		contenturl:"/view/base/BasTimedTaskLog",
//		submiturl:"/BasTimedTaskLog/saveBasTimedTaskLog",
		callback:reloadBasTimedTaskLog
	});
	
}

//修改记录
function editBasTimedTaskLog() {
	var row = BasTimedTaskLogDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.taskLogId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasTimedTaskLog&id=" + id,
			submiturl:"/BasTimedTaskLog/saveBasTimedTaskLog?formcode=BasTimedTaskLog",
//			contenturl : "/view/base/BasTimedTaskLog",
//			submiturl : "/BasTimedTaskLog/saveBasTimedTaskLog",
//			onload : "/BasTimedTaskLog/findBasTimedTaskLog?id=" + id,
			callback : reloadBasTimedTaskLog
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasTimedTaskLog() {
	var row = BasTimedTaskLogDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.taskLogId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasTimedTaskLog/delBasTimedTaskLog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasTimedTaskLogDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
