var basegrid=$('#BasSysOptlog_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasSysOptlog_datagrid_tb",
	    url:ctx+'/BasSysOptlog/pageBasSysOptlog',
	    columns:[[
	    {field:'LOG_ID',title:'',hidden:true},
	    {field:'OPERATE_NAME',title:'操作描述',width:100,align:'left'},
	    {field:'OPERATE_TIME',title:'操作时间',width:100,align:'left'},
	    {field:'OPERATE_ACCOUNT',title:'操作人',width:100,align:'left'},
	    {field:'OPERATE_IP',title:'操作IP',width:100,align:'left'},
	    {field:'OPERATE_METHOD',title:'访问方法',width:200,align:'left'},
	    {field:'OPERATE_RESULT',title:'访问状态',width:50,
	    formatter: function(value,row,index){
				if (value=='N'){
					return "失败";
				} else {
					return "正常";
				}
			}
		},
	    {field:'OPERATE_DETAIL',title:'明细',width:100,align:'center',halign:'center',
	    formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
							return '<div onclick="showDetail(\''+index+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
					}}
	    ]],
	    rowStyler: function(index,row){
			if (row.OPERATE_RESULT=='N'){
				return 'background-color:red;color:white;';
			}
		}
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasSysOptlog_datagrid',"操作日志信息");   
	        }    
	    }]   
	}); 
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasSysOptlog(){
	basegrid.datagrid('load',{
		search:$("#searchBasSysOptlog").val()
	});
}


//删除记录
function delBasSysOptlog() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.LOG_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasSysOptlog/delBasSysOptlog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

function showDetail(index){
	basegrid.datagrid('selectRow',index);
	var content=basegrid.datagrid('getSelected').OPERATE_DETAIL;
	$('#BasSysOptlog_dialog').dialog({   
		content:content
	}); 
	$('#BasSysOptlog_dialog').dialog('open'); 
}

function showconsolelog(){
	openDetailDialog({
		title:"控制台日志",
		width:500,
		height:400,
		contenturl:'/view/base/consolelogs'
	})
}
