var BasGroupDataGrid=$('#BasGroup_datagrid');
$(function(){
	initBasGroupGrid();
});

function initBasGroupGrid(){
	BasGroupDataGrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		height:$("body").height()-140,
		toolbar:"#BasGroup_datagrid_tb",
	    url:ctx+'/BasGroup/pageBasGroup',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasGroupFormDetail('+row.groupId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
/*	    {field:'groupId',title:'主键',width:100,align:'center',halign:'center'},*/
	    {field:'groupName',title:'组名称',width:100,align:'center',halign:'center'},
		{field:'groupComponentText',title:'组成员',width:200,align:'left',halign:'left'},
		{field:'groupTypeText',title:'组类型',width:100,align:'left',halign:'left'},
	    {field:'statusText',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'createAccountName',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasGroupFormDetail(row.groupId);
	    }
	});
    BasGroupDataGrid.datagrid('doCellTip');
    var pager = BasGroupDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasGroup_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasGroupFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasGroup&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasGroup(){
	BasGroupDataGrid.datagrid('reload');
}
//查询表格
function searchBasGroup(){
	BasGroupDataGrid.datagrid('load',{
		// search:$("#searchBasGroup").val()
		groupName:$("#groupName").textbox('getValue'),
		groupComponent:$("#qgroupComponent").textbox('getValue')
	});
}

//增加记录
function addBasGroup() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasGroup",
		submiturl:"/BasGroup/saveBasGroup?formcode=BasGroup",
//		contenturl:"/view/base/BasGroup",
//		submiturl:"/BasGroup/saveBasGroup",
		callback:reloadBasGroup
	});
	
}

//修改记录
function editBasGroup() {
	var row = BasGroupDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.groupId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasGroup&id=" + id,
			submiturl:"/BasGroup/saveBasGroup?formcode=BasGroup",
//			contenturl : "/view/base/BasGroup",
//			submiturl : "/BasGroup/saveBasGroup",
			onload : function(){
				$("#groupComponent").val(row.groupComponent);
				$("#groupComponent_TEXT_").textbox('setValue',row.groupComponentText);
			},
			callback : reloadBasGroup
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasGroup() {
	var row = BasGroupDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.groupId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasGroup/delBasGroup",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasGroupDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
