var BasFormLinkDataGrid=$('#BasFormLink_datagrid');
$(function(){
	initBasFormLinkGrid();
});

function initBasFormLinkGrid(){
	BasFormLinkDataGrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasFormLink_datagrid_tb",
	    url:ctx+'/BasFormLink/pageBasFormLink',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasFormLinkFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',title:'id',width:100,align:'center',halign:'center'},
	    {field:'formCode',title:'表单编码',width:100,align:'center',halign:'center'},
	    {field:'formName',title:'表单名称',width:100,align:'center',halign:'center'},
	    {field:'formIco',title:'图标',width:100,align:'center',halign:'center'},
	    {field:'docType',title:'公文类型',width:100,align:'center',halign:'center'},
	    {field:'tempId',title:'模板id',width:100,align:'center',halign:'center'},
	    {field:'displayNo',title:'排序',width:100,align:'center',halign:'center'},
	    {field:'enable',hidden:true},
	    {field:'enableText',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'remark',title:'说明',width:100,align:'center',halign:'center'},
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    BasFormLinkDataGrid.datagrid('doCellTip');
    var pager = BasFormLinkDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasFormLink_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasFormLinkFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFormLink&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasFormLink(){
	BasFormLinkDataGrid.datagrid('reload');
}
//查询表格
function searchBasFormLink(){
	BasFormLinkDataGrid.datagrid('load',{
		search:$("#searchBasFormLink").val()
	});
}

//增加记录
function addBasFormLink() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasFormLink",
		submiturl:"/BasFormLink/saveBasFormLink?formcode=BasFormLink",
//		contenturl:"/view/base/BasFormLink",
//		submiturl:"/BasFormLink/saveBasFormLink",
		callback:reloadBasFormLink
	});
	
}

//修改记录
function editBasFormLink() {
	var row = BasFormLinkDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasFormLink&id=" + id,
			submiturl:"/BasFormLink/saveBasFormLink?formcode=BasFormLink",
//			contenturl : "/view/base/BasFormLink",
//			submiturl : "/BasFormLink/saveBasFormLink",
//			onload : "/BasFormLink/findBasFormLink?id=" + id,
			callback : reloadBasFormLink
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasFormLink() {
	var row = BasFormLinkDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasFormLink/delBasFormLink",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasFormLinkDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
