var basetree=$('#BasBank_tree');
var baseform=$('#BasBank_form');
var commonId;
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/BasBank/treeBasBankWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(commonId){
				var newnode = $(this).tree('find',commonId);
				$(this).tree('expandTo', newnode.target);
				$(this).tree('select', newnode.target);
			}else{
				if(node){
					$(this).tree('select', node.target);
				}else{
					$(this).tree('collapseAll');
					$(this).tree('expand',root.target);
					$(this).tree('select', root.target);
				}
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delBasBank').linkbutton('enable'); //删除
		$('#saveBasBank').linkbutton('enable'); //保存
	}else{
		$('#delBasBank').linkbutton('disable');
		$('#saveBasBank').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(!node){
		return;
	}
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/BasBank/findBasBank?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetBasBank(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addBasBank() {
	var node = basetree.tree('getSelected');
	if(node){
		// 清除当前界面信息
		baseform.form('clear');	
			$('#bankPid').combotree('setValue',node.id);
			$('#bankType').combobox('setValue',node.attributes.banktype);
		$('#saveBasBank').linkbutton('enable');
	}else{
		alertError("请先选择一个左侧节点");
		return false;
	}
}
//删除
function delBasBank() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/BasBank/delBasBankAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function saveBasBank(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/BasBank/saveBasBank",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveBasBank').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					// 获取选中的节点
					var resultnode = basetree.tree('find',result.o.bankId);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						if(selectnode.bankId!=result.o.bankPid){
							basetree.tree("reload");
							commonId=result.o.bankId
						}else{
							basetree.tree('update', {
								target : selectnode.target,
								text : result.o.bankName
								
							});
						}
					} else {
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
										id:result.o.bankId,
										text:result.o.bankName
									}]
								});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',result.o.bankId);
					basetree.tree('select', newnode.target);
					$('#saveBasBank').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#saveBasBank').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function pushPubBank() {
    var selectnode = basetree.tree('getSelected');
    if (selectnode) {
        alertConfirmYes('您是否要推送当前银行信息到财务系统？', function (r) {
            if (r) {
                var loadIndex = layer.msg('数据同步中...', {
                    icon: 16,
                    shade: 0.3, time: 0
                });
                $.ajax({
                    type: 'post',
                    url: ctx + "/eassync/synBank",
                    data: {
                        id: selectnode.id
                    },
                    dataType: 'json',
                    success: function (result) {
                        layer.close(loadIndex);
                        if (result.success) {
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    },
                    error: function () {
                        layer.close(loadIndex);
                        alertInfo("数据同步出错");
                    }
                });
            }
        });
    } else {
        alertInfo('请先选择要推送的数据');
    }
}
