var basetree=$('#${table.entityName}_tree');
var baseform=$('#${table.entityName}_form');
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/${table.entityName}/tree${table.entityName}WithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#del${table.entityName}').linkbutton('enable'); //删除
		$('#save${table.entityName}').linkbutton('enable'); //保存
	}else{
		$('#del${table.entityName}').linkbutton('disable');
		$('#save${table.entityName}').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/${table.entityName}/find${table.entityName}?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}

function reset${table.entityName}(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function add${table.entityName}() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	baseform.form('clear');	
	<#list table.columns as po>
	<#if po.fieldDbName ==table.treepid>
		$('#${po.fieldName}').combotree('setValue',node.id);
	</#if>
	</#list>
	$('#save${table.entityName}').linkbutton('enable');
}

//删除
function del${table.entityName}() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/${table.entityName}/del${table.entityName}AndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function save${table.entityName}(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/${table.entityName}/save${table.entityName}",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#save${table.entityName}').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
				<#list table.columns as po>
				  <#if po.fieldDbName ==table.treepid>
					$('#${po.fieldName}').combotree('reload');
				  </#if>
				</#list>
					// 获取选中的节点
					var resultnode = basetree.tree('find',<#list table.columns as po><#if po.fieldDbName ==table.treeid>result.o.${po.fieldName}</#if></#list>);
					if (resultnode) {// 通过节点上是否有该节点判断 新增还是修改
						basetree.tree('update', {
									target : selectnode.target,
									<#list table.columns as po>
									<#if po.fieldDbName ==table.treetext>
									text : result.o.${po.fieldName}
									</#if>
									</#list>
									
								});
					} else {
						basetree.tree('append', {
									parent : selectnode.target,
									data : [{
											<#list table.columns as po><#if po.fieldDbName ==table.treeid>id:result.o.${po.fieldName},</#if></#list>
											<#list table.columns as po><#if po.fieldDbName ==table.treetext>text:result.o.${po.fieldName}</#if></#list>
											}]
								});
					}
					alertInfo(result.msg);
					var newnode = basetree.tree('find',<#list table.columns as po><#if po.fieldDbName ==table.treeid>result.o.${po.fieldName}</#if></#list>);
					basetree.tree('select', newnode.target);
					newnode.attributes=result.o;
					$('#save${table.entityName}').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#save${table.entityName}').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}
