select
===
with tmp as
 (select TT.COMPONENT_ID,
           GROUP_CONCAT(concat(tt.user_type,':',tt.user_id))  user_id,
           GROUP_CONCAT((case
                     when tt.user_type = 'dept' then
                      getdeptname(tt.user_id)
                     when tt.user_type = 'org' then
                      getbaseabbr(tt.user_id)
                     when tt.user_type = 'user' then
                      getaccountname(tt.user_id)
                   end) ORDER BY tt.COMPONENT_ID) user_name
      from gm_space_component_user tt
     where tt.is_use = 'Y'
     group by tt.COMPONENT_ID)
select @pageTag(){
		t.COMPONENT_ID,
		t.COMPONENT_NAME,
		t.COMPONENT_WIDTH,
		t.COMPONENT_HEIGHT,
		t.COMPONENT_SOURCE,
		GETDICNAME('COMPONENT_SOURCE',t.COMPONENT_SOURCE) COMPONENT_SOURCE_TEXT,
		t.COMPONENT_CATEGORY,
		GETDICNAME('COMPONENT_CATEGORY',t.COMPONENT_CATEGORY) COMPONENT_CATEGORY_TEXT,
		t.CREATION_TYPE,
		GETDICNAME('SYS_DATA_CREATION_TYPE',t.CREATION_TYPE) CREATION_TYPE_TEXT,
		t.ORG_ID,
		b.ORG_NAME,
		t.LINK_ADDRESS,
		t.CREATE_ACCOUNT,
		t.CREATE_TIME,
		t.MODIFY_ACCOUNT,
		t.MODIFY_TIME,
		t.IS_USE,
		p.user_id,
        p.user_name,
		t.open_type
	 @}
from GM_SPACE_COMPONENT_DEFINITION t
left join BAS_ORG b on t.ORG_ID=b.ORG_ID
left join tmp p on t.COMPONENT_ID = p.COMPONENT_ID
where t.is_use = 'Y'
@if(!isEmpty(search)){
and t.COMPONENT_NAME like #search#
@}
@if(!isEmpty(componentName)){
and t.COMPONENT_NAME like #componentName#
@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.COMPONENT_ID desc
    @}
    @if(!isEmpty(sort)){
   	 order by #text(sort)# #text(order)#
    @}
@}



findAll
===
select t.*
from GM_SPACE_COMPONENT_DEFINITION t
where t.is_use = 'Y'


spaceComponentTree
===
SELECT 	t.COMPONENT_ID id, 
     	t.COMPONENT_NAME text 
 FROM 	GM_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'

spaceComponentTreeFilter
===
SELECT 	t.COMPONENT_ID id, 
     	t.COMPONENT_NAME text 
 FROM 	GM_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'
 and 
 (
 t.COMPONENT_ID in (select COMPONENT_ID from gm_space_component_user where user_id = #userId# and is_use = 'Y')
 or
 (SELECT count(1) FROM GM_SPACE_COMPONENT_ASSOCIATED where FIND_IN_SET(t.COMPONENT_ID,COMPONENT_ID) and COMPONENT_TYPE = '2' and SPACE_ID = 460 and is_use = 'Y') > 0
 )
 
getSpaceComponentByCategory
===
SELECT 	t.COMPONENT_ID value, 
     	t.COMPONENT_NAME text 
 FROM 	GM_SPACE_COMPONENT_DEFINITION t
 where t.is_use = 'Y'
 and t.component_Category=#category#
ORDER BY t.COMPONENT_ID asc

getUseSpace
===
select group_concat(s.SPACE_NAME)
from gm_space_define s,gm_space_component_associated a
where s.IS_USE='Y'
AND A.IS_USE='Y'
AND concat(',',a.COMPONENT_ID,',') like concat('%,',#id#,',%')
and s.SPACE_ID = a.SPACE_ID