/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.util;

import com.ibm.icu.text.DecimalFormat;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String EMPTY = "";

    public static boolean isEmpty(Object obj) {
        return obj == null || EMPTY.equals(obj.toString()) || "null".equals(obj) || "NULL".equals(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return !StringUtil.isEmpty(obj);
    }

    public static String null2String(Object obj) {
        return obj == null || "null".equals(obj) || "NULL".equals(obj) ? EMPTY : obj.toString();
    }

    public static Long strToLong(Object obj) {
        return StringUtil.isEmpty(obj) ? null : Long.valueOf(Long.parseLong(obj.toString()));
    }

    public static Integer strToInt(Object obj) {
        return StringUtil.isEmpty(obj) ? null : Integer.valueOf(Integer.parseInt(obj.toString()));
    }

    public static Float strToFloat(Object obj) {
        return StringUtil.isEmpty(obj) ? null : Float.valueOf(Float.parseFloat(obj.toString()));
    }

    public static Double strToDouble(Object obj) {
        return StringUtil.isEmpty(obj) ? null : Double.valueOf(Double.parseDouble(obj.toString()));
    }

    public static Boolean strToBoolean(Object obj) {
        return StringUtil.isEmpty(obj) ? false : Boolean.parseBoolean(obj.toString());
    }

    public static Character strToChar(Object obj) {
        return Character.valueOf(StringUtil.isEmpty(obj) ? (char)' ' : ((Character)obj).charValue());
    }

    public static Byte strToByte(Object obj) {
        return StringUtil.isEmpty(obj) ? (byte)0 : Byte.parseByte(obj.toString());
    }

    public static Short strToShort(Object obj) {
        return StringUtil.isEmpty(obj) ? (short)0 : Short.parseShort(obj.toString());
    }

    public static long str2Long(Object obj) {
        return StringUtil.isEmpty(obj) ? 0L : Long.parseLong(obj.toString());
    }

    public static int str2Int(Object obj) {
        return StringUtil.isEmpty(obj) ? 0 : Integer.parseInt(obj.toString());
    }

    public static float str2Float(Object obj) {
        return StringUtil.isEmpty(obj) ? 0.0f : Float.parseFloat(obj.toString());
    }

    public static double str2Double(Object obj) {
        return StringUtil.isEmpty(obj) ? 0.0 : Double.parseDouble(obj.toString());
    }

    public static Double str2NullDouble(Object obj) {
        if (StringUtil.isEmpty(obj)) {
            return null;
        }
        return Double.parseDouble(obj.toString());
    }

    public static boolean str2Boolean(Object obj) {
        return StringUtil.isEmpty(obj) ? false : Boolean.parseBoolean(obj.toString());
    }

    public static char str2Char(Object obj) {
        return StringUtil.isEmpty(obj) ? (char)' ' : ((Character)obj).charValue();
    }

    public static byte str2Byte(Object obj) {
        return StringUtil.isEmpty(obj) ? (byte)0 : Byte.parseByte(obj.toString());
    }

    public static short str2Short(Object obj) {
        return StringUtil.isEmpty(obj) ? (short)0 : Short.parseShort(obj.toString());
    }

    public static String array2CommaStr(String[] names) {
        String rs = "('')";
        if (names != null && names.length > 0) {
            StringBuilder result = new StringBuilder("(");
            for (String string : names) {
                result.append("'" + string.toString() + "',");
            }
            rs = result.substring(0, result.length() - 1) + ")";
        }
        return rs;
    }

    public static String list2CommaStr(List<?> names) {
        String rs = "('')";
        if (names != null && !names.isEmpty()) {
            StringBuilder result = new StringBuilder("(");
            for (Object o : names) {
                result.append("'" + o.toString() + "',");
            }
            rs = result.substring(0, result.length() - 1) + ")";
        }
        return rs;
    }

    public static String getCurrentMethodName() {
        return new Exception().getStackTrace()[1].getMethodName();
    }

    public static StringBuffer escapeJson(String s) {
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public static String getLikeStr(String str) {
        return StringUtil.getLikeStr(str, EMPTY);
    }

    public static String getLikeStr(String str, String type) {
        if (type.isEmpty()) {
            str = "%" + str + "%";
        } else if ("L".equals(type)) {
            str = "%" + str;
        } else if ("R".equals(type)) {
            str = str + "%";
        }
        return str;
    }

    public static String transYN(String str) {
        if ("Y".equals(str)) {
            return "\u662f";
        }
        if ("N".equals(str)) {
            return "\u5426";
        }
        return EMPTY;
    }

    public static int compareDouble(Double v1, Double v2, int num) {
        BigDecimal bd1 = new BigDecimal(v1);
        bd1 = bd1.setScale(num, 4);
        BigDecimal bd2 = new BigDecimal(v2);
        bd2 = bd2.setScale(num, 4);
        return bd1.compareTo(bd2);
    }

    public static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static String numFormat(Double v) {
        DecimalFormat df = new DecimalFormat("##0.0000");
        return df.format((Object)v);
    }

    public static String moneyFormat(Double v) {
        DecimalFormat df = new DecimalFormat("##0.00");
        return df.format((Object)v);
    }

    public static String moneyFormat2(Double v) {
        DecimalFormat df = new DecimalFormat("#,##0.00");
        return df.format((Object)v);
    }

    public static String priceFormat(Double v) {
        DecimalFormat df = new DecimalFormat("###.00000000");
        return df.format((Object)v);
    }

    public static String escapStr(String str) {
        if (!StringUtil.isEmpty(str)) {
            return str.replaceAll("\"", "&quot;");
        }
        return EMPTY;
    }

    public static String strChange(Object str) {
        Pattern CRLF;
        Matcher m;
        if (!StringUtil.isEmpty(str) && (m = (CRLF = Pattern.compile("(\r\n|\r|\n|\n\r)")).matcher(str.toString())).find()) {
            return m.replaceAll("<br/>");
        }
        return EMPTY;
    }

    public static int getCount(String str, String subStr) {
        int result = 0;
        while (str.contains(subStr)) {
            str = str.substring(str.indexOf(subStr) + subStr.length(), str.length());
            ++result;
        }
        return result;
    }

    public static String escapeHtml(List<String> needEscapHtml, String str) {
        String result = EMPTY;
        return StringUtil.escapeHtmlAll(str);
    }

    public static String escapeHtmlAll(String str) {
        String result = EMPTY;
        result = str.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\u00a9", "&copy;");
        result = result.replaceAll("\u00ae", "&reg;");
        result = result.replaceAll("\u2122", "\u2122");
        result = result.replaceAll("\u00d7", "&times;");
        result = result.replaceAll("\u00f7", "&divide;");
        return result;
    }
}

