/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.report.service;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ustc.base.common.util.DataSourceutil;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.CommonService;
import com.ustc.gen.util.FreeMarkerUtil;
import com.ustc.report.dao.ReportBaseChartDao;
import com.ustc.report.dao.ReportBaseColumnDao;
import com.ustc.report.dao.ReportBaseDao;
import com.ustc.report.dao.ReportBaseDsDao;
import com.ustc.report.entity.ReportBase;
import com.ustc.report.entity.ReportBaseChart;
import com.ustc.report.entity.ReportBaseColumn;
import com.ustc.report.entity.ReportBaseDs;
import com.ustc.report.entity.ReportBean;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportBaseService {
    private static final Logger logger = Logger.getLogger(ReportBaseService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ReportBaseDao reportbaseDao;
    @Autowired
    private ReportBaseColumnDao reportBaseColumnDao;
    @Autowired
    private ReportBaseChartDao reportBaseChartDao;
    @Autowired
    private ReportBaseDsDao reportBaseDsDao;
    @Autowired
    private DataSourceutil dataSourceutil;

    public ReportBase findReportBase(Long id) {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        return entity;
    }

    public ReportBean genReport(String reportCode, LoginUser user, HttpServletRequest request) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ReportBean bean = new ReportBean();
        HashMap<String, Object> freemarkmap = new HashMap<String, Object>();
        freemarkmap.put("loginuser", user);
        ReportBase reportold = this.reportbaseDao.findByReportCodeAndIsUse(reportCode, "Y");
        ReportBase report = (ReportBase)BeanUtils.cloneBean((Object)reportold);
        report.setDataOptions(FreeMarkerUtil.instance().genString(report.getDataOptions(), freemarkmap));
        bean.setReport(report);
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            freemarkmap.put(paraName, request.getParameter(paraName));
        }
        if (StringUtils.isNotBlank((String)report.getDataOptions())) {
            report.setDataOptions(FreeMarkerUtil.instance().genString(report.getDataOptions(), freemarkmap));
        }
        if (StringUtils.isNotBlank((String)report.getReportScript())) {
            report.setReportScript(FreeMarkerUtil.instance().genString(report.getReportScript(), freemarkmap));
        }
        if ("1".equals(report.getReportType())) {
            List<ReportBaseColumn> columns = this.getColumnsByReportId(report.getId());
            for (ReportBaseColumn column : columns) {
                if ("Y".equals(column.getIsSearch())) {
                    bean.addSearchColumns(column);
                }
                if (!"Y".equals(column.getIsHidden())) {
                    if ("Y".equals(column.getIsFrozen())) {
                        bean.addFrozenColumns(column, column.getRowNum() == null ? 0 : column.getRowNum().intValue());
                    } else {
                        bean.addColumns(column, column.getRowNum() == null ? 0 : column.getRowNum().intValue());
                    }
                }
                column.setSearchOptions(FreeMarkerUtil.instance().genString(column.getSearchOptions(), freemarkmap));
            }
        } else if ("2".equals(report.getReportType())) {
            List<ReportBaseChart> charts = this.reportBaseChartDao.findByReportIdAndIsUse(report.getId(), "Y");
            for (ReportBaseChart chart : charts) {
                ReportBaseDs ds = (ReportBaseDs)this.reportBaseDsDao.findById(chart.getDsId()).get();
                String sqlstr = FreeMarkerUtil.instance().genString(ds.getSqlScript(), freemarkmap);
                chart.setData(this.sqlHelper.queryByNativeSQL(sqlstr, new int[0]));
                if (!StringUtils.isNotBlank((String)chart.getClassField())) continue;
                ArrayList<String> series = new ArrayList<String>();
                StringBuilder seriesSql = new StringBuilder("select \n");
                for (Map<?, ?> map : chart.getData()) {
                    if (ObjectUtil.isEmpty(map.get(chart.getNameField()))) {
                        logger.warn((Object)(reportCode + "\u62a5\u8868\u6709\u5206\u7c7b\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565"));
                        continue;
                    }
                    String serie = map.get(chart.getNameField()).toString();
                    if (series.contains(serie)) continue;
                    series.add(serie);
                    seriesSql.append("max(DECODE_VARCHAR(" + chart.getNameField() + ",'" + serie + "'," + chart.getValueField() + ",0)) \"" + serie + "\",\n");
                }
                chart.setSeries(series);
                seriesSql.append(chart.getClassField());
                seriesSql.append("\n from(" + sqlstr + ")o \n");
                seriesSql.append(" group by ");
                seriesSql.append(chart.getClassField());
                seriesSql.append("\n order by \n");
                seriesSql.append(chart.getClassField());
                logger.info((Object)("\n\u6267\u884csql: \n" + seriesSql));
                chart.setData(this.sqlHelper.queryByNativeSQL(seriesSql.toString(), new int[0]));
            }
            bean.setCharts(charts);
        }
        return bean;
    }

    public List<ReportBaseColumn> getColumnsByReportId(Long reportId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*, ");
        sql.append("(with recursive temp as(\n\t\t\t\t select a.*,1 level from report_base_column a where  a.id=t.id\n\t\t\t\t union all\n\t\t\t\t select a.*,temp.level+1 level  from report_base_column a,temp where temp.parent_field=a.column_code and a.REPORT_ID=temp.REPORT_ID)\n\t\t\t\t select group_concat( a.column_code order by level) from temp a) PARENT_FIELDS ");
        sql.append(" from REPORT_BASE_COLUMN t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        sql.append(" and t.report_id=:reportId ");
        params.put("reportId", reportId);
        sql.append(" order by case when t.IS_HIDDEN='Y' then 2 else 1 end,case when t.IS_FROZEN='Y' then 1 else 2 end ,t.row_num,t.order_by");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return JSON.parseArray((String)JSON.toJSONString((Object)list), ReportBaseColumn.class);
    }

    public void saveReportBase(ReportBase entity, String rows) {
        List list;
        Long id = entity.getId();
        this.reportbaseDao.save(entity);
        if ("1".equals(entity.getReportType())) {
            Map<String, Map<String, Object>> columns = this.dataSourceutil.getColunms(entity.getSqlScript());
            Long i = 0L;
            for (Map.Entry<String, Map<String, Object>> entry : columns.entrySet()) {
                Map<String, Object> map = entry.getValue();
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
                if (!this.reportBaseColumnDao.findByReportIdAndColumnCode(entity.getId(), map.get("name").toString()).isEmpty()) continue;
                ReportBaseColumn column = new ReportBaseColumn();
                column.setColumnName(map.get("name").toString());
                column.setColumnCode(map.get("name").toString());
                Long precision = Long.parseLong(map.get("precision").toString());
                precision = precision > 500L ? 500L : (precision < 100L ? 100L : precision);
                column.setColumnWidth(precision);
                column.setReportId(entity.getId());
                column.setIsUse("Y");
                column.setOrderBy(i);
                column.setColumnColspan(1L);
                column.setColumnRowspan(1L);
                column.setRowNum(0L);
                column.setIsFrozen("N");
                column.setIsSearch("N");
                column.setIsHidden("N");
                column.setColumnAlign("center");
                this.reportBaseColumnDao.save(column);
            }
            List list2 = JSON.parseArray((String)rows, ReportBaseColumn.class);
            if (list2 != null) {
                if (list2.size() > 0) {
                    for (ReportBaseColumn column : list2) {
                        column.setReportId(entity.getId());
                        column.setIsUse(entity.getIsUse());
                    }
                }
                this.reportBaseColumnDao.saveAll(list2);
            }
        } else if ("2".equals(entity.getReportType()) && (list = JSON.parseArray((String)rows, ReportBaseChart.class)) != null) {
            if (list.size() > 0) {
                for (ReportBaseChart chart : list) {
                    chart.setReportId(entity.getId());
                    chart.setIsUse(entity.getIsUse());
                }
            }
            this.reportBaseChartDao.saveAll(list);
        }
    }

    public void copyReportBase(Long id) throws IllegalAccessException, InvocationTargetException {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        ReportBase newreport = new ReportBase();
        ConvertUtils.register((Converter)new DateConverter(null), Date.class);
        BeanUtils.copyProperties((Object)newreport, (Object)entity);
        newreport.setId(null);
        newreport.setReportCode(newreport.getReportCode() + "clone" + System.currentTimeMillis());
        newreport.setReportName(newreport.getReportName() + "\u526f\u672c");
        this.reportbaseDao.save(newreport);
        List<ReportBaseColumn> list = this.reportBaseColumnDao.findByReportIdAndIsUseOrderByOrderBy(id, "Y");
        ArrayList<ReportBaseColumn> nlist = new ArrayList<ReportBaseColumn>(list.size());
        for (ReportBaseColumn col : list) {
            ReportBaseColumn nColumn = new ReportBaseColumn();
            BeanUtils.copyProperties((Object)nColumn, (Object)col);
            nColumn.setId(null);
            nColumn.setReportId(newreport.getId());
            nlist.add(nColumn);
        }
        this.reportBaseColumnDao.saveAll(nlist);
        List<ReportBaseDs> listds = this.reportBaseDsDao.findByReportIdAndIsUse(id, "Y");
        ArrayList<ReportBaseDs> nlistds = new ArrayList<ReportBaseDs>(listds.size());
        for (ReportBaseDs ds : listds) {
            ReportBaseDs nds = new ReportBaseDs();
            BeanUtils.copyProperties((Object)nds, (Object)ds);
            nds.setId(null);
            nds.setReportId(newreport.getId());
            nlistds.add(nds);
        }
        this.reportBaseDsDao.saveAll(nlistds);
        List<ReportBaseChart> listchart = this.reportBaseChartDao.findByReportIdAndIsUse(id, "Y");
        ArrayList<ReportBaseChart> nlistchart = new ArrayList<ReportBaseChart>(listchart.size());
        for (ReportBaseChart chart : listchart) {
            ReportBaseChart nchart = new ReportBaseChart();
            BeanUtils.copyProperties((Object)nchart, (Object)chart);
            nchart.setId(null);
            nchart.setReportId(newreport.getId());
            nlistchart.add(nchart);
        }
        this.reportBaseChartDao.saveAll(nlistchart);
    }

    public void delReportBase(Long id) {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        entity.setIsUse("N");
        this.reportbaseDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,getaccountname(t.CREATE_BY) CREATE_BY_TEXT_  ");
        sql.append(" from REPORT_BASE t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.ID) like :search ");
            sql.append(" or upper(t.REPORT_NAME) like :search ");
            sql.append(" or upper(t.REPORT_CODE) like :search ");
            sql.append(" or upper(t.SQL_SCRIPT) like :search ");
            sql.append(" or upper(t.REPORT_TYPE) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.CREATE_BY) like :search ");
            sql.append(" or upper(t.CREATE_TIME) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.REPORT_SCRIPT) like :search ");
            sql.append(" or upper(t.DATA_OPTIONS) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") temp  " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("REPORT_TYPE", "reportType");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject queryReport(String search, int page, int rows, String sort, String order, Long id, LoginUser user, HttpServletRequest request) {
        PageObject pageobject = new PageObject();
        ReportBase report = (ReportBase)this.reportbaseDao.findById(id).get();
        List<ReportBaseColumn> columns = this.reportBaseColumnDao.findByReportIdAndIsUseOrderByOrderBy(report.getId(), "Y");
        Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(report.getSqlScript());
        HashMap<String, Object> freemarkmap = new HashMap<String, Object>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            freemarkmap.put(paraName, request.getParameter(paraName));
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        freemarkmap.put("loginuser", user);
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select * from(select *   \n");
        for (ReportBaseColumn reportBaseColumn : columns) {
            if (!sqlcolumns.containsKey(reportBaseColumn.getColumnCode()) && !sqlcolumns.containsKey(reportBaseColumn.getColumnCode().toLowerCase()) || !StringUtils.isNotBlank((String)reportBaseColumn.getDicCode())) continue;
            sql.append(",getdicname('" + reportBaseColumn.getDicCode() + "'," + reportBaseColumn.getColumnCode() + ") " + reportBaseColumn.getColumnCode() + "_TEXT_\n");
            dicmapper.put(reportBaseColumn.getColumnCode(), reportBaseColumn.getDicCode());
        }
        sql.append("from (\n");
        sql.append(report.getSqlScript());
        sql.append(" )t)t where 1=1 \n");
        HashMap<String, Object> sumColumns = new HashMap<String, Object>();
        for (ReportBaseColumn column : columns) {
            if ("Y".equals(column.getIsSum())) {
                sumColumns.put(column.getColumnCode(), new BigDecimal(0));
            }
            freemarkmap.put(column.getColumnCode(), request.getParameter(column.getColumnCode()));
            if (StringUtils.isNotBlank((String)request.getParameter(column.getColumnCode()))) {
                if (sqlcolumns.containsKey(column.getColumnCode()) || sqlcolumns.containsKey(column.getColumnCode().toLowerCase())) {
                    sql.append(" and t." + column.getColumnCode() + (StringUtils.isNotBlank((String)column.getDicCode()) ? "_TEXT_" : "") + " like :" + column.getColumnCode() + " \n");
                }
                if (!sqlcolumns.containsKey(column.getColumnCode()) && !sqlcolumns.containsKey(column.getColumnCode().toLowerCase()) && !report.getSqlScript().contains(":" + column.getColumnCode())) continue;
                params.put(column.getColumnCode(), "%" + request.getParameter(column.getColumnCode()) + "%");
                continue;
            }
            sql = new StringBuilder(sql.toString().replaceAll("(=|<|>|<=|>=|)\\s*:" + column.getColumnCode() + "\\b", " is not null"));
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
            sql.append(" and  ( 1=2 ");
            for (ReportBaseColumn column : columns) {
                if (!sqlcolumns.containsKey(column.getColumnCode()) && !sqlcolumns.containsKey(column.getColumnCode().toLowerCase())) continue;
                sql.append(" or upper(cast(t." + column.getColumnCode() + " as char)) like :search ");
                if (!StringUtils.isNotBlank((String)column.getDicCode())) continue;
                sql.append(" or upper(cast(t." + column.getColumnCode() + "_TEXT_ as char)) like :search ");
            }
            sql.append(") ");
        }
        String string = FreeMarkerUtil.instance().genString(sql.toString(), freemarkmap);
        try {
            if (StrKit.notBlank(sort)) {
                String exesql = "select t.* from (" + string + ") t " + SysUtils.genOrderBy("t." + sort, order);
                logger.info((Object)("\n\u6267\u884csql: \n" + exesql));
                logger.info((Object)("\n\u53c2\u6570: " + JSON.toJSONString(params)));
                pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
            } else {
                logger.info((Object)("\n\u6267\u884csql: \n" + string));
                logger.info((Object)("\n\u53c2\u6570: " + JSON.toJSONString(params)));
                pageobject = this.sqlHelper.pagerNativeSQL(string, params, (Integer)page, (Integer)rows);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u62a5\u8868\u67e5\u8be2\u51fa\u9519:" + e.getMessage()));
        }
        if (!sumColumns.isEmpty()) {
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d|\\.]*$");
            ArrayList<HashMap<String, Object>> footer = new ArrayList<HashMap<String, Object>>(1);
            for (Object obj : pageobject.getRows()) {
                Map map = (Map)obj;
                for (String columnCode : sumColumns.keySet()) {
                    if (map.get(columnCode) == null || !pattern.matcher(map.get(columnCode).toString()).matches()) continue;
                    sumColumns.put(columnCode, ((BigDecimal)sumColumns.get(columnCode)).add(new BigDecimal(map.get(columnCode).toString())));
                }
            }
            for (ReportBaseColumn column : columns) {
                if ("Y".equals(column.getIsHidden())) continue;
                sumColumns.put(column.getColumnCode(), "\u5408\u8ba1");
                break;
            }
            footer.add(sumColumns);
            pageobject.setFooter(footer);
        }
        return pageobject;
    }
}

