/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.report.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.service.CommonService;
import com.ustc.report.dao.ReportBaseColumnDao;
import com.ustc.report.entity.ReportBaseColumn;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportBaseColumnService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ReportBaseColumnDao reportbasecolumnDao;

    public ReportBaseColumn findReportBaseColumn(Long id) {
        ReportBaseColumn entity = (ReportBaseColumn)this.reportbasecolumnDao.findById(id).get();
        return entity;
    }

    public void saveReportBaseColumn(ReportBaseColumn entity) {
        this.reportbasecolumnDao.save(entity);
    }

    public void delReportBaseColumn(Long id) {
        ReportBaseColumn entity = (ReportBaseColumn)this.reportbasecolumnDao.findById(id).get();
        entity.setIsUse("N");
        this.reportbasecolumnDao.save(entity);
    }

    public List<Object> queryAll(String search, Long id) {
        List list = null;
        if (id == null) {
            return list;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,r.COLUMN_NAME  PARENT_FIELD_TEXT_ ");
        sql.append(" from REPORT_BASE_COLUMN t  ");
        sql.append(" left join REPORT_BASE_COLUMN r on t.PARENT_FIELD=r.COLUMN_CODE and t.report_id=r.report_id and r.is_use=:isUse ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        sql.append(" and t.report_id=:reportId ");
        params.put("reportId", id);
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.COLUMN_NAME) like :search ");
            sql.append(" or upper(t.COLUMN_CODE) like :search ");
            sql.append(" or upper(t.COLUMN_WIDTH) like :search ");
            sql.append(" or upper(t.COLUMN_COLSPAN) like :search ");
            sql.append(" or upper(t.COLUMN_ROWSPAN) like :search ");
            sql.append(" or upper(t.COLUMN_ALIGN) like :search ");
            sql.append(" or upper(t.STYLER_FUNCTION) like :search ");
            sql.append(" or upper(t.ORDER_BY) like :search ");
            sql.append(" or upper(t.DIC_CODE) like :search ");
            sql.append(" or upper(t.DATA_URL) like :search ");
            sql.append(" or upper(t.SEARCH_OPTIONS) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by case when t.IS_HIDDEN='Y' then 2 else 1 end,case when t.IS_FROZEN='Y' then 1 else 2 end,t.row_num,t.order_by");
        list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("COLUMN_ALIGN", "columnAlign");
        dicmapper.put("COLUMN_TYPE", "COLUMN_TYPE");
        this.commonService.fmtListWithDic(list, dicmapper);
        return list;
    }
}

