/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.Pinyin4jUtil;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.BasMessageService;
import com.ustc.base.service.CommonService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubContactDao;
import com.ustc.pub.dao.PubContactOrgAccountDao;
import com.ustc.pub.dao.PubContactOrgDao;
import com.ustc.pub.dao.PubContactOrgTypeDao;
import com.ustc.pub.entity.PubContact;
import com.ustc.pub.entity.PubContactOrg;
import com.ustc.pub.entity.PubContactOrgAccount;
import com.ustc.pub.entity.PubContactOrgType;
import com.ustc.pub.service.PubContactOrgAccountService;
import com.ustc.pub.service.PubContactOrgTypeService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class PubContactOrgService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private PubContactOrgDao pubcontactorgDao;
    @Autowired
    private PubContactOrgTypeDao pubcontactorgtypeDao;
    @Autowired
    private PubContactOrgTypeService pubContactOrgTypeService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private PubContactOrgAccountService pubContactOrgAccountService;
    @Autowired
    private PubContactOrgAccountDao pubContactOrgAccountDao;
    @Autowired
    private PubContactDao pubContactDao;
    @Autowired
    private BasMessageService msgService;

    public PubContactOrg findPubContactOrg(Long id) {
        PubContactOrg entity = (PubContactOrg)this.pubcontactorgDao.findById(id).get();
        return entity;
    }

    public void savePubContactOrg(PubContactOrg entity) {
        this.pubcontactorgDao.save(entity);
    }

    public String queryContactOrgNameByIds(String contactOrgIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgIds", contactOrgIds);
        return this.bSqlHelper.getStringValue("pub.PubContactOrg.searchMulti", params);
    }

    public PubContactOrg savePubContactOrg(PubContactOrg entity, FormFileBean formfile) {
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        String pinyin = Pinyin4jUtil.getPinyinJianPin(entity.getContactOrgName());
        if (pinyin.length() > 1000) {
            pinyin = pinyin.substring(0, 1000);
        }
        entity.setToNamePinyin(pinyin);
        this.pubcontactorgDao.save(entity);
        if (entity.getDataPCOAList() != null) {
            for (PubContactOrgAccount oa : entity.getDataPCOAList()) {
                if (StringUtils.isEmpty((Object)oa.getContactOrgId())) {
                    oa.setContactOrgId(entity.getContactOrgId());
                }
                if (StringUtils.isEmpty((Object)oa.getIsUse())) {
                    oa.setStatus("1");
                    oa.setIsUse("Y");
                }
                if (oa.getWorkflowStatus() == null) {
                    oa.setWorkflowStatus(SysContent.PASS_STATUS);
                }
                this.pubContactOrgAccountDao.save(oa);
            }
        }
        if (entity.getDataContactList() != null) {
            for (PubContact contact : entity.getDataContactList()) {
                if (StringUtils.isEmpty((Object)contact.getContactOrgId())) {
                    contact.setContactOrgId(entity.getContactOrgId());
                }
                if (StringUtils.isEmpty((Object)contact.getIsUse())) {
                    contact.setIsUse("Y");
                }
                this.pubContactDao.save(contact);
            }
        }
        formfile.setPrimaryKey(entity.getContactOrgId());
        formfile.setAccountid(entity.getModifyAccount());
        this.docFormFileService.SaveFormFileBean(formfile);
        return entity;
    }

    public void delPubContactOrg(Long id) {
        PubContactOrg entity = (PubContactOrg)this.pubcontactorgDao.findById(id).get();
        entity.setIsUse("N");
        this.pubcontactorgDao.save(entity);
        List<PubContact> contacts = this.pubContactDao.findByContactOrgIdAndIsUse(id, "Y");
        if (contacts != null && contacts.size() > 0) {
            for (PubContact contact : contacts) {
                contact.setIsUse("N");
                this.pubContactDao.save(contact);
            }
        }
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public List<Map<String, Object>> findListByContactOrgId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", id);
        return this.bSqlHelper.getMapList("business.pm.PubContactOrgAccount.select", params);
    }

    public List<Map<String, Object>> findByContactOrgId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", id);
        return this.bSqlHelper.getMapList("business.pm.PubContactOrgAccount.selectWin", params);
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order, Long contactOrgTypeId, String type, String contactType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)type)) {
            params.put("type", type);
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)contactType)) {
            params.put("contactType", "%" + contactType.toUpperCase() + "%");
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        }
        params.put("contactOrgTypeId", contactOrgTypeId);
        return this.bSqlHelper.serachPage("pub.PubContactOrg.select", params, PageRequest.of((int)page, (int)rows));
    }

    public PubContactOrg findByProcessinstid(long processinstid) {
        return this.pubcontactorgDao.findByProcessinstid(processinstid);
    }

    public JsonMsg checkrepeat(PubContactOrg entity) {
        JsonMsg msg = new JsonMsg();
        PubContactOrgType type = this.pubContactOrgTypeService.findPubContactOrgType(entity.getContactOrgTypeId());
        if ("1".equals(type.getType())) {
            if (entity.getContactOrgName().length() > 4 && StrKit.notBlank(entity.getContactOrgName()) && this.hasrepeatOrgName(entity.getContactOrgName(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u5355\u4f4d\u540d\u79f0/\u59d3\u540d\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
            if (StrKit.notBlank(entity.getContactOrgCode()) && this.hasrepeatOrgCode(entity.getContactOrgCode(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u7edf\u4e00\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
        } else if ("2".equals(type.getType())) {
            if (entity.getContactOrgName().length() > 4 && StrKit.notBlank(entity.getContactOrgName()) && this.hasrepeatOrgName(entity.getContactOrgName(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u5355\u4f4d\u540d\u79f0/\u59d3\u540d\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
            if (StrKit.notBlank(entity.getContactOrgCode()) && this.hasrepeatOrgCode(entity.getContactOrgCode(), entity.getContactOrgId(), type.getType())) {
                msg.setSuccess(false);
                msg.setMsg("\u7edf\u4e00\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u91cd\u590d");
                return msg;
            }
        }
        return msg;
    }

    public JsonMsg checkContactOrgData(String orgName, String contactOrgCode, String type, Long contactOrgId) {
        JsonMsg msg = new JsonMsg();
        if ("1".equals(type)) {
            if (this.hasrepeatOrgName(orgName, contactOrgId, type) && orgName.length() <= 4) {
                msg.setSuccess(false);
                msg.setMsg("\u5df2\u5b58\u5728\u5355\u4f4d\u540d\u79f0/\u59d3\u540d,\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?");
                return msg;
            }
        } else if ("2".equals(type) && this.hasrepeatOrgName(orgName, contactOrgId, type) && orgName.length() <= 4) {
            msg.setSuccess(false);
            msg.setMsg("\u5df2\u5b58\u5728\u5355\u4f4d\u540d\u79f0/\u59d3\u540d,\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?");
            return msg;
        }
        return msg;
    }

    public boolean hasrepeatOrgName(String orgname, Long contactorgid, String type) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where replace(replace(trim(t.contact_org_name), '\uff08', '('), '\uff09', ')') =");
        sql.append(" replace(replace(?1, '\uff08', '('), '\uff09', ')') and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        if (StrKit.notBlank(type)) {
            sql.append(" and t.type = " + type);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{orgname.trim()})).toString()) > 0L;
    }

    public boolean hasrepeatOrgCode(String orgcode, Long contactorgid, String type) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where  trim(t.contact_org_code)= ?1 and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        if (StrKit.notBlank(type)) {
            sql.append(" and t.type = " + type);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{orgcode.trim()})).toString()) > 0L;
    }

    public boolean hasrepeatIdCard(String idcard, Long contactorgid) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from PUB_CONTACT_ORG t where  trim(t.id_card)= ?1 and t.is_use='Y' ");
        if (contactorgid != null && contactorgid != 0L) {
            sql.append(" and t.contact_org_id <> " + contactorgid);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{idcard.trim()})).toString()) > 0L;
    }

    public void back(Long processinstid) {
        PubContactOrg o = this.findByProcessinstid(processinstid);
        o.setModifyTime(new Date());
        o.setWorkflowStatus(SysContent.BACK_STATUS);
        this.pubcontactorgDao.save(o);
    }

    public PageObject PageAllSelWin(String type, String pubContactOrgIds, String search, int page, int rows, String sort, String order, Long contactOrgTypeId, Long contactOrgTypeCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrKit.notBlank(pubContactOrgIds)) {
            params.put("pubContactOrgIds", pubContactOrgIds);
        }
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        params.put("type", type);
        params.put("contactOrgTypeId", contactOrgTypeId);
        params.put("contactOrgTypeCode", contactOrgTypeCode);
        return this.bSqlHelper.serachPage("pub.PubContactOrg.selectWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject pagePubContactBlockSelWin(String contactOrgTypeId, String type, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)contactOrgTypeId)) {
            params.put("contactOrgTypeId", contactOrgTypeId);
        }
        params.put("type", type);
        return this.bSqlHelper.serachPage("pub.PubContactOrg.selectBlockWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PubContactOrgType findPubContactOrgTypeByPubContactOrgId(Long contactOrgId) {
        PubContactOrg pubContactOrg = (PubContactOrg)this.pubcontactorgDao.findById(contactOrgId).get();
        PubContactOrgType pubContactOrgType = (PubContactOrgType)this.pubcontactorgtypeDao.findById(pubContactOrg.getContactOrgTypeId()).get();
        return pubContactOrgType;
    }

    public PageObject pageContactOrg(Long conId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (conId != null && conId != 0L) {
            params.put("conId", conId);
        }
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrg.pageContactOrg", params, PageRequest.of((int)page, (int)rows));
    }

    public Long countContact(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null && id != 0L) {
            params.put("id", id);
        }
        return this.bSqlHelper.getLongValue("pub.PubContactOrg.countContact", params);
    }

    public PageObject getContractOrgByCon(String currentLat, String currentLng, String distance, String type, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((Object)type)) {
            params.put("type", type);
        }
        if (!StringUtils.isEmpty((Object)currentLat)) {
            params.put("currentLat", currentLat);
        }
        if (!StringUtils.isEmpty((Object)currentLng)) {
            params.put("currentLng", currentLng);
        }
        if (!StringUtils.isEmpty((Object)distance)) {
            params.put("distance", distance);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrg.getContractOrgByCon", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getConByContractOrg(Long contractOrgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractOrgId", contractOrgId);
        return this.bSqlHelper.getMapList("pub.PubContactOrg.getConByContractOrg", params);
    }

    public String getOtherPartsText(String ids) {
        if (ids != null) {
            String[] contactOrgIds;
            String otherPartsText = "";
            for (String contactOrgId : contactOrgIds = ids.split(",")) {
                String contactOrgName = this.findPubContactOrg(Long.parseLong(contactOrgId)).getContactOrgName();
                otherPartsText = otherPartsText + contactOrgName + ",";
            }
            return otherPartsText.substring(0, otherPartsText.length() - 1);
        }
        return null;
    }

    public String selectNameById(String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)id)) {
            params.put("id", id);
        }
        return this.bSqlHelper.getStringValue("pub.PubContactOrg.selectNameById", params);
    }
}

